	TITLE	'TV950-EMULATION F]R TERMINAL MIT NS405/455'
	SBTTL	"C'T TEXT-TERMINAL SOFTWARE V2.2"
	WIDTH	80
	NOLIST
	INCLUD	EQUATES.ASM
	LIST
	ORG	1000H		; BANK 2

; T. REH 26.07.89

; UNTERPROGRAMME IN ANDEREN MODULEN

INIT	EQU	0AH		; GESAMTINIT. TERMINAL
CI	EQU	0CH		; CONSOLE INPUT IN R3
CO	EQU	0EH		; CONSOLE OUTPUT IN R3
HLOOP	EQU	10H		; HAUPTSCHLEIFE TERMINAL

; EINSPRUNGVEKTOR F]R ANDERE MODULE

	JMP	CTLCOD		; CONTROL-CODE AUSWERTUNG
	JMP	CRIGHT		; CURSOR RIGHT
	JMP	CURUP		; CURSOR UP
	JMP	CDOWN		; CURSOR DOWN
	JMP	CTLCD2		; EINSPRUNG F]R ZUS. CTL-CODES
	JMP	STSET		; STATUSZEILE AUFFRISCHEN
	JMP	SDISP		; AUSGABEROUTINE STATUSZEILE
	JMP	FFD		; BILDSCHIRM L\SCHEN
	JMP	CLRPG1		; TEIL BILDSCHIRM L\SCHEN
	JMP	LDSEND		; BILD-ENDADRESSE NACH A
	JMP	EDISP		; TERMINAL-EMULATION ANZEIGEN
	JMP	NDISP		; NATIONALIT[T ANZEIGEN
	JMP	BDISP		; BAUDRATE ANZEIGEN
	JMP	STMODE		; ONLINE/LOCAL/SETUP ANZEIGEN
	JMP	CDISP		; SPALTENZAHL ANZEIGEN
	JMP	RDISP		; ZEILENZAHL ANZEIGEN

;**************************************************************
;**                                                          **
;**             STATUSZEILEN - BEARBEITUNG                   **
;**                                                          **
;**************************************************************

; STSET SCHREIBT GESAMTE STATUSZEILE.

STSET:	CALL	CLRSTA		; STATUSZEILE L\SCHEN
	MOV	A,@R1		; REG4 LESEN
	JB7	STSET1		; STATUSZEILE AN : WERTE ANZ.
	RET
STSET1:	CALL	STMOD1		; ONLINE/LOCAL/SETUP ANZEIGEN
	MOV	A,R7		; BOOLEAN FLAG
	CPL	A
	JB1	STST1		; CTL MODE ?
	CALL	STCTL
STST1:	CALL	STHAND		; HANDSHAKE DTR/XON ANZEIGEN
	CALL	STBITS		; DATA+PARITY+STOP BITS ANZ.
	MOV	R3,#23		; SPALTE-1
	CALL	LDSEND		; STARTADRESSE ZIELZEILE
	CALL	BDISP		; BAUDRATE ANZEIGEN
	MOV	R2,#LOW(BAUD)	; TEXT
	MOV	R3,#29		; SPALTE-1
	MOV	R4,#2		; 2 ZEICHEN
	CALL	STEND		; 'Bd' SCHREIBEN
	MOV	R3,#34		; ZIELSPALTE-1 (EMULATION)
	CALL	LDSEND
	CALL	EDISP		; TERMINAL-EMULATION ANZ.
	MOV	R3,#41		; ZIELSPALTE-1 (NAT.)
	CALL	LDSEND
	CALL	NDISP		; NATIONALIT[T ANZEIGEN
	MOV	R3,#46
	CALL	LDSEND
	CALL	CDISP		; SPALTENZAHL AB SPALTE 47
	MOV	A,#'x'
	MOVX	@R1,A		; TRENNZEICHEN 'x'
	MOV	R3,#49
	CALL	LDSEND
	CALL	RDISP		; ZEILENZAHL AB SPALTE 50
	CALL	LDSEND
	ADD	A,#9		; ERSTE TRENNZEICHEN-SPALTE
	MOVL	R1,A		; ZEIGER AUF STATUSZEILE
	MOVX	A,@R1		; ATTR HOLEN
	MOV	A,HACC
	ANL	A,#7FH		; GRAFIK-ATTR SETZEN
	MOV	HACC,A
	MOV	A,#4AH		; SENKRECHTER BALKEN
	MOVL	R0,A		; ZEICHEN/ATTR RETTEN
	MOVX	@R1,A		; ANZEIGEN
	MOVL	A,R1
	ADD	A,#23		; 23 SPALTEN WEITER
	MOVL	R1,A
	MOVL	A,R0
	MOVX	@R1,A		; TRENNZEICHEN
	MOVL	A,R1
	ADD	A,#20		; 20 SPALTEN WEITER
	MOVL	R1,A
	MOVL	A,R0
	MOVX	@R1,A		; TRENNZEICHEN
	MOVL	A,R1
	ADD	A,#10		; 10 SPALTEN WEITER
	MOVL	R1,A
	MOVL	A,R0
	MOVX	@R1,A		; TRENNZEICHEN
	INCL	R1
	INCL	R1
	INCL	R1
	INCL	R1
	MOVX	A,@R1		; ORIG. ATTR HOLEN
	MOV	A,#':'
	MOVX	@R1,A		; TRENNZEICHEN F]R UHR
	INCL	R1
	INCL	R1
	INCL	R1
	MOVX	@R1,A		; TRENNZEICHEN F]R UHR
	RET

; ROUTINE F]R 'CONTROL MODE'.

STCTL:	MOV	R2,#LOW(CTLMD)	; TEXT
	MOV	R3,#5		; SPALTE-1
	JMP	ST3END

; ROUTINE F]R 'DTR' UND 'XON' HANDSHAKE-MODE-ANZEIGE.

STHAND:	MOV	R3,#11		; SPALTE-1 VORBELEGEN
	MOV	R1,#REG4
	MOV	A,@R1		; REG4
	MOV	R2,#LOW(HDSXON)	; TEXTZEIGER FALLS XON
	JB5	STHX		; XON ?
	MOV	R2,#LOW(HDSDTR)	; TEXTZEIGER FALLS DTR
STHX:	JMP	ST3END		; AUSGEBEN

; ANZAHL DATENBITS, PARITY, UND ANZAHL STOPBITS ANZEIGEN.

STBITS:	CALL	LDSEND
	ADD	A,#16		; SPALTE-1
	MOVL	R0,A		; ZEIGER F]R AUSGABEN
	MOVX	A,@R0		; ALTER WERT WEGEN ATTR.
	MOV	R1,#REG5
	MOV	A,@R1
	ANL	A,#1		; BIT0: WORTBREITE
	ADD	A,#'7'
	MOVX	@R0,A		; 7 ODER 8 DATENBITS
	INCL	R0
	MOV	A,#'+'		; DURCH '+' GETRENNT
	MOVX	@R0,A
	INCL	R0
	MOV	R1,#REG6
	MOV	A,@R1
	JB1	STPAR1		; PARITY ENABLE: ANZEIGEN
	MOV	A,#'n'
	JMP	STPARX		; SONST 'NO' PARITY
STPAR1:	ANL	A,#0CH		; NUR PARITY
	RR	A
	RR	A		; WERTE 0..3
	ADD	A,#LOW(PBTAB)
	MOVP	A,@A		; BUCHSTABE AUS TABELLE
STPARX:	MOVX	@R0,A		; ANZEIGEN
	INCL	R0
	MOV	A,#'+'		; DURCH '+' GETRENNT
	MOVX	@R0,A
	INCL	R0
	MOV	A,@R1
	ANL	A,#1		; BIT0: STOP BITS
	ADD	A,#'1'
	MOVX	@R0,A		; 1 ODER 2 STOPBITS
	RET

PBTAB:	DB	'oems'		; PARITY-CODES

; ROUTINE F]R BAUDRATE DER SERIELLEN SCHNITTSTELLE.

BDISP:	MOVL	R0,A		; ZEILENADRESSE RETTEN
	MOV	R1,#REG6
	MOV	A,@R1
	SWAP	A
	ANL	A,#0FH		; BAUDRATE 4 BIT
	MOV	R2,A
	RL	A
	RL	A		; * 4
	ADD	A,R2		; * 5
	ADD	A,#LOW(BAUDS)
	MOV	R2,A
	MOVL	A,R0		; ZEILENADRESSE HOLEN
	JMP	ST5DSP		; ZAHLEN SCHREIBEN

; ROUTINE F]R ANZEIGE DER AKT. TERMINAL-EMULATION.
; OFFSET (SPALE MINUS 1) IN R3.

EDISP:	MOV	R2,#LOW(TE)	; ZEIGER AUF TEXTANFANG
ST5DSP:	MOV	R4,#5		; 5 ZEICHEN
	JMP	SDISP		; AUSGEBEN (ZEILENANF. IN A)

; ANZEIGE DER AKTUELLEN SPALTENZAHL.

CDISP:	MOVL	R0,A
	MOV	R1,#REG5
	MOV	A,@R1
	ANL	A,#0C0H		; NUR SPALTENZAHL
	SWAP	A
	RR	A		; 2 * SPALTENZAHL
	ADD	A,#LOW(COL72)
CDISP1:	MOV	R2,A
	MOVL	A,R0
	MOV	R4,#2		; 2 ZEICHEN
	JMP	SDISP

; ANZEIGE DER AKTUELLEN ZEILENZAHL.

RDISP:	MOVL	R0,A
	MOV	R1,#REG5
	MOV	A,@R1
	ANL	A,#30H		; NUR ZEILENZAHL
	SWAP	A
	RL	A		; 2 * ZEILENZAHL
	ADD	A,#LOW(ROW22)
	JMP	CDISP1

; ROUTINE F]R ANGABE DES NATIONALEN ZEICHENSATZES.

NDISP:	MOVL	R0,A		; ZEILENADRESSE RETTEN
	MOV	R1,#REG5
	MOV	A,@R1
	RR	A
	ANL	A,#7		; 3 BIT ZEICHENSATZ
	ADD	A,#LOW(NTTAB)
	MOVP	A,@A		; TEXTANFANG ENTSPR. ZS
	MOV	R2,A
	MOVL	A,R0		; ZEILENADRESSE HOLEN
	MOV	R4,#3		; 3 ZEICHEN
	JMP	SDISP		; AUSGEBEN

NTTAB:	DB	N0,N1,N2,N3,N4,N5,N6,N7

; ROUTINE F]R 'ONLINE', 'LOCAL' UND 'SETUP'.
; KANN AUCH DURCH INTERRUPT-ROUTINE AUFGERUFEN WERDEN (EXTINT).

STMODE:	MOV	R1,#REG4
	MOV	A,@R1		; REG4 LESEN
	JB7	STMOD1		; STATUSZEILE EINGESCHALTET?
	RET			; SONST UNVER[NDERT RETURN
STMOD1:	MOV	R3,#0		; SPALTE-1 VORBELEGEN
	MOV	R1,#7
	MOV	A,@R1		; BOOLEAN FLAG
	MOV	R2,#LOW(LOC)	; TEXTZEIGER FALLS LOCAL
	JB0	ST3END		; LOCAL ?
	MOV	R2,#LOW(SET)	; TEXTZEIGER FALLS SETUP
	JB2	ST3END		; SETUP ?
	MOV	R2,#LOW(ONL)	; TEXTZEIGER FALLS ONLINE

; AUSGABEROUTINE F]R STATUSZEILE.

ST3END:	MOV	R4,#3		; 3 ZEICHEN
STEND:	CALL	LDSEND		; ANFANG STATUSZEILE
SDISP:	ADD	A,R3		; ZEIGER AUF TEXTZIEL
	MOVL	R1,A		; NACH R1
SDISP1:	MOVX	A,@R1		; ALTER WERT WEGEN ATTRIBUTEN
	MOV	A,R2		; ZEIGER AUF QUELLE
	MOVP	A,@A		; ZEICHEN
	MOVX	@R1,A		; ZEICHEN SCHREIBEN
	INCL	R1
	INC	R2
	DJNZ	R4,SDISP1	; ALLE ZEICHEN ]BERTRAGEN
	RET

; TEXTE F]R STATUSZEILE.

ONL:	DB	'ONL'
LOC:	DB	'LOC'
SET:	DB	'SET'
HDSDTR:	DB	'DTR'
HDSXON:	DB	'XON'
CTLMD:	DB	'CTL'
BAUDS:	DB	'  110'
	DB	'134.5'
	DB	'  150'
	DB	'  300'
	DB	'  600'
	DB	' 1200'
	DB	' 1800'
	DB	' 2400'
	DB	' 3600'
	DB	' 4800'
	DB	' 7200'
	DB	' 9600'
	DB	'19200'
	DB	'19200'
	DB	'19200'
	DB	' 9600'
BAUD:	DB	'Bd'
TE:	DB	'TV950'
N0:	DB	'USA'
N1:	DB	'FRA'
N2:	DB	'GER'
N3:	DB	'ENG'
N4:	DB	'DEN'
N5:	DB	'SWE'
N6:	DB	'ITA'
N7:	DB	'SPA'
COL72:	DB	'72'
COL80:	DB	'80'
    IF Z20820
	DB	'7280'
    ELSE
	DB	'88'
     IF Z17300
	DB	'92'
     ELSE
	DB	'96'
     ENDIF
    ENDIF
ROW22:	DB	'22'
ROW24:	DB	'24'
ROW26:	DB	'26'
    IF Z17300 OR Z17550 OR Z20820
ROW28:	DB	'27'
    ELSE
ROW28:	DB	'28'
    ENDIF

;**************************************************************
;**                                                          **
;**             ELEMENTARE TERMINAL-FUNKTIONEN               **
;**                                                          **
;**************************************************************

; CLRPAG L\SCHT BILDSCHIRM, SETZT CURSOR UND HOME AUF 0.

CLRPAG:	CLR	A
	MOV	HACC,A
CLRPG1:	MOV	HOME,A
	MOV	CURS,A		; HOME UND CURS AUF 0
	MOVL	R0,A		; ZEIGER F]R CLRLNP
	MOV	R1,#ROWNUM
	MOV	A,@R1
	MOV	R5,A		; ZEILENANZAHL NACH R5
CPLOOP:	CALL	CLRLNP		; R0-ZEILE L\SCHEN
	DJNZ	R5,CPLOOP
	RET

; CLRHOM L\SCHT AKTUELLE HOME-ZEILE, CLRLIN DIE DURCH A
; ADRESSIERTE ZEILE, CLRLNP DIE DURCH R0 ADR. ZEILE.

CLRHOM:	MOV	A,HOME
CLRLIN:	MOVL	R0,A		; R0 ALS ADRESSZEIGER
CLRLNP:	MOV	R1,#ROWLEN
	MOV	A,@R1
	MOV	R2,A		; ZEILENL[NGE NACH R2
CLRLN0:	MOV	A,#0FFH
	MOV	HACC,A		; KEINE ATTRIBUTE GESETZT
	MOV	A,#' '
CLRLN1:	MOVX	@R0,A		; BLANK IN SPEICHER SCHREIBEN
	INCL	R0
	DJNZ	R2,CLRLN1	; EINE GANZE ZEILE LANG
	RET

; BELL: PULS (LOW) AN GLOCKE AUSGEBEN.

BELL:	ANL	PORT,#NOT BELBIT	; BIT SETZEN (NEG PULS)
	ORL	PORT,#BELBIT		; BIT WIEDER R]CKSETZEN
	RET

; CLRSTA L\SCHT STATUSZEILE (HALF INTEN, REVERSE).

CLRSTA:	CALL	LDSEND		; STATUS HINTER BILDSPEICHER
	MOVL	R0,A		; R0 ALS ADRESSZEIGER
	MOV	R1,#ROWLEN
	MOV	A,@R1
	MOV	R2,A		; ZEILENL[NGE IN R2
	MOV	R1,#REG4
	MOV	A,@R1		; REG4 LESEN
	RLC	A		; STA-ON IN CY, REVVID IN BIT4
	SWAP	A		; REVVID IN BIT0
	RLC	A		; KOMBI IN BIT0..1
	ANL	A,#3
	ADD	A,#LOW(STATTB)	; ZEIGER AUF ATTR-BYTE
	MOVP	A,@A
	MOV	HACC,A		; ATTRIBUTE F]R STATUSZEILE
	MOV	A,#' '
CLRST1:	MOVX	@R0,A		; BLANK IN SPEICHER SCHREIBEN
	INCL	R0
	DJNZ	R2,CLRST1	; EINE GANZE ZEILE LANG
	RET

STATTB:	DB	10111111B	; NOREV, OFF
	DB	11111100B	; NOREV, ON
	DB	10111110B	; REV, OFF
	DB	11111101B	; REV, ON

; DIE FOLGENDEN 3 UNTERPROGRAMME TESTEN DEN INHALT VON HACC/A
; AUF SPEICHERENDE (EODCHK), BILDENDE (EOSCHK) UND BILDANFANG
; (TODCHK). NUR HACC/A UND R1 WERDEN BENUTZT. DAS CARRY-FLAG
; WIRD GESETZT, WENN DAS ENTSPR. ENDE ]BERSCHRITTEN WURDE.

EODCHK:	MOV	R1,#ENDLO
	CPL	A
	ADD	A,@R1		; ADDIEREN [NDERT HACC !
	MOV	A,HACC
	CPL	A
	JNC	EOD1		; AUF ]BERLAUF PR]FEN
	ADD	A,#2		; BORROW STATT CARRY !
	JZ	EODX
EOD1:	INC	R1		; ACHTUNG! INC L\SCHT CARRY!
	ADD	A,@R1		; HIGH-BYTES VERGLEICHEN
EODX:	CPL	C		; CARRY WENN ACCU GR\SSER
	RET

EOSCHK:	MOV	R1,#ROWNUM
	MOV	A,@R1		; ZEILENZAHL
	CPL	A		; -ANZAHL-1
	ADD	A,R5		; ZEILENNUMMER > ANZAHL ?
	RET

TODCHK:	CLR	C		; CARRY VORBELEGEN
	MOV	A,HACC
	CPL	A
	JB7	TODX		; POSITIV : KEIN CARRY
	CPL	C		; NEGATIV : CARRY SETZEN
TODX:	RET

; DIESES UNTERPROGRAMM L[DT DIE H\CHSTE BILDADRESSE NACH A.

LDSEND:	MOV	R1,#ENDHI
	MOV	A,@R1		; HIGH-BYTE
	MOV	HACC,A
	DEC	R1
	MOV	A,@R1		; LOW-BYTE
	RET

;**************************************************************
;**                                                          **
;**                  CURSOR - BEWEGUNG                       **
;**                                                          **
;**************************************************************

; CURSOR UP (OBERSTE ZEILE = ANSCHLAG)

CUP:	CALL	CURUP		; CURSOR UP
	SEL	MB0
	JMP	HLOOP

CURUP:	DJNZ	R5,CUP1		; ZEILE -1 UND TESTEN AUF 0
	INC	R5		; ZEILE WAR 1 : ZEILE BLEIBT 1
	RET			; KEINE VER[NDERUNG
CUP1:	MOV	R1,#ROWLEN	; ZEILE WAR GR\SSER ALS 1 :
	MOV	A,@R1
	MOV	R1,A		; ZEILENL[NGE NACH R1
	CPL	A
	MOV	R2,A		; R2 : -L[NGE-1
CUP2:	DEC	CURS
	DJNZ	R1,CUP2		; CURSOR EINE ZEILE R]CKW[RTS
	MOV	A,CURS
	CALL	TODCHK		; SPEICHERANFANG ?
	JNC	CUPX		; NEIN : ENDE
	CALL	LDSEND		; SONST NACH SPEICHERENDE
	ADD	A,R2		; AUF ADRESSE VOR ZEILENANFANG
	MOV	R1,A		; A RETTEN
	MOV	A,HACC
	DEC	A
	MOV	HACC,A		; HACC -1 WEIL ADDIERT 
	MOV	A,R1		; A WIEDERHOLEN
	ADD	A,R6		; SPALTE RICHTIG SETZEN
	MOV	CURS,A		; NEUEN CURSOR RETTEN
CUPX:	RET

; CURSOR DOWN (UNTERSTE ZEILE = ANSCHLAG).

CDN:	CALL	CDOWN
	SEL	MB0
	JMP	HLOOP

CDOWN:	INC	R5		; ZEILE ERH\HEN
	CALL	EOSCHK
	JC	CDOWN1
	JMP	LFD1		; LINEFEED AUSF]HREN
CDOWN1:	DEC	R5		; ZUR]CK AUF VORIGE ZEILE
	RET			; BILDENDE : ANSCHLAG

; CURSOR LEFT (ZEILENR]CKGANG, ENDE IN ECKE LINKS OBEN).

BSP:	CALL	CLEFT		; BEWEGEN
	SEL	MB0
	JMP	HLOOP

CLEFT:	MOV	A,R6		; SPALTE
	DJNZ	R6,CLEFT1	; ERNIEDRIGEN, FALLS >1: CLEFT1
	MOV	R1,#ROWLEN
	MOV	A,@R1
	MOV	R6,A		; [USSERST RECHTE SPALTE
	DJNZ	R5,CLEFT0	; VORIGE ZEILE ; OBEN ?
	INC	R5
	MOV	R6,#1		; IN ECKE BLEIBEN
	RET
CLEFT0:	MOV	A,CURS
	DEC	A
	CALL	TODCHK		; SPEICHERANFANG ?
	JNC	CLEFT1
	CALL	LDSEND		; FALLS JA, AUF SPEICHERENDE
	MOV	CURS,A
CLEFT1:	DEC	CURS		; CURSOR NACH LINKS
	RET

; CURSOR RIGHT (NEW LINE BEI ]BERLAUF, EVTL. SCROLLEN).

CRG:	CALL	CRIGHT
	SEL	MB0
	JMP	HLOOP

CRIGHT:	INC	CURS		; CURSORPOSITION ERH\HEN
	INC	R6		; SPALTE + 1
	MOV	R1,#ROWLEN
	MOV	A,@R1
	CPL	A		; -L[NGE-1 IN A
	ADD	A,R6		; ZEILENENDE ?
	JNC	CRGHTX		; NICHT ZEILENENDE : WEITER
	INC	R5		; N[CHSTE ZEILE
	MOV	R6,#1		; SPALTE 1
	CALL	EOSCHK
	JC	SCROLL		; BEI BILDENDE : SCROLLEN
	MOV	A,CURS
	CALL	EODCHK		; SPEICHERENDE ?
	JNC	CRGHTX		; NEIN, N[CHSTES ZEICHEN
	CLR	A
	MOV	HACC,A
	MOV	CURS,A		; CURS AUF SPEICHERANFANG
CRGHTX:	RET

SCROLL:	DEC	R5		; BILDENDE : R5 WIEDER ZUR]CK
	CALL	CLRHOM		; DERZEITIGE HOME-ZEILE L\SCHEN
	MOV	A,HOME
	MOV	CURS,A		; ALTE HOME-POS.= NEUE CURS-POS.
	ADD	A,@R1		; HOME AUF N[CHSTE Z. (SCROLL)
	MOV	HOME,A
	CALL	EODCHK		; SPEICHERENDE ?
	JNC	SCROLX
	CLR	A
	MOV	HACC,A
	MOV	HOME,A		; WENN JA, HOME WIEDER AUF 0
SCROLX:	RET

; CARRIAGE RETURN.

CAR:	DEC	CURS
	DJNZ	R6,CAR		; SPALTENZAHL R]CKW[RTS GEHEN
	INC	CURS
	INC	R6		; SPALTE = 1
	SEL	MB0
	JMP	HLOOP

; LINE FEED. BEI DOPPELTER H\HE ZWEI ZEILEN NACH UNTEN.

LFD:	CALL	LNFD
	MOV	R0,#CURATT
	MOV	A,@R0		; CURRENT ATTRIBUTE
	JB3	LFX		; NORMALE H\HE
	CALL	LNFD		; SONST NOCH'N LINEFEED
LFX:	SEL	MB0
	JMP	HLOOP

LNFD:	INC	R5		; ZEILE ERH\HEN
	CALL	EOSCHK		; BILDENDE ?
	JNC	LFD1		; NEIN...
	DEC	R5		; WIEDER AUF ALTE ZEILE ZUR]CK
	CALL	CLRHOM		; HOME-ZEILE L\SCHEN
	MOV	A,HOME
	ADD	A,@R1		; HOME AUF N[CHSTE ZEILE
	MOV	HOME,A
	CALL	EODCHK		; SPEICHERENDE ?
	JNC	LFD1
	CLR	A
	MOV	HACC,A
	MOV	HOME,A		; HOME AUF SPEICHERANFANG
LFD1:	MOV	R1,#ROWLEN
	MOV	A,@R1
	MOV	R1,A		; ZEILENL[NGE NACH R1
	MOV	A,CURS
	ADD	A,R1		; CURSOR EINE ZEILE WEITER
	MOV	CURS,A
	CALL	EODCHK		; SPEICHERENDE ?
	JNC	LFDX
	CLR	A		; WENN JA :
	MOV	HACC,A		;   VON NULL AN WEITER
	MOV	A,R6		;   SPALTE WIEDERHERSTELLEN !
	DEC	A
	MOV	CURS,A		; NEUE CURSORPOSITION LADEN
LFDX:	RET

; FORM FEED BEARBEITUNG. L\SCHT DEN BILDSCHIRM UND SETZT CURSOR
; NACH LINKS OBEN.

FFD:	CALL	CLRPAG		; SEITE L\SCHEN
	JMP	HOM0		; ZEILE UND SPALTE AUF 1 SETZEN

; HORIZONTALER TABULATOR. DIE STOPS SIND JEWEILS 8 SPALTEN.

HZT:	CALL	CRIGHT		; CURSOR NACH RECHTS
	MOV	A,R6		; SPALTE
	DEC	A		; AB NULL NORMIEREN
	ANL	A,#7
	JNZ	HZT		; WEITER BIS AUF TAB-SPALTE
	SEL	MB0
	JMP	HLOOP

; HOME CURSOR.

HOM:	MOV	A,HOME
	MOV	CURS,A		; CURSOR AUF HOME-POSTION SETZEN
HOM0:	MOV	A,#1
	MOV	R5,A
	MOV	R6,A		; ZEILE UND SPALTE AUF 1
HOMX:	SEL	MB0
	JMP	HLOOP

;**********************************************************
;**                                                      **
;**       ES FOLGT DER EMULATIONS-SPEZIFISCHE TEIL       **
;**                                                      **
;**********************************************************

; HIER WERDEN DIE CONTROL-CODES AUSGEWERTET. NICHT IMPLEMEN-
; TIERTE CODES WERDEN IGNORIERT.

CTLCOD:	MOV	A,R3		; ZEICHEN
	ANL	A,#7FH		; NUR 7 BIT G]LTIG
	MOV	R3,A		; NACH R3 ZUR WEITEREN BEARB.
	XRL	A,#ESC		; ESCAPE ?
	JZ	ESCSEQ
	MOV	R2,#LOW(TV950C)
CTLCD1:	MOV	A,R2		; R2 ZEIGT AUF TABELLE
	CALL	GETTR		; ERSTES ZEICHEN AUS TABELLE
	JZ	IGNORE		; 0 = TABELLENENDE
	INC	R2		; ZEIGER AUF ERGEBNIS
	XRL	A,R3
	JZ	FOUND		; EINGANG ERKANNT
	INC	R2
	JMP	CTLCD1		; SONST WEITERSUCHEN
FOUND:	MOV	A,R2
	CALL	GETTR		; ERGEBNIS AUS TABELLE
CTLCD2:	ADD	A,#LOW(INDTAB)
	JMPP	@A		; DURCH TABELLE ANSPRINGEN

ESCSEQ:	SEL	MB0		; ESC-SEQUENZ:
	CALL	CI		; N[CHSTES ZEICHEN HOLEN
	SEL	MB2
	MOV	R2,#LOW(TV950E)
	JMP	CTLCD1		; WIE CONTROLCODE VERARBEITEN

; INDIREKTE SPRUNGTABELLE F]R CONTROL-/ESCAPE- CODES.

INDTAB:	DB	CODE00,CODE01,CODE02,CODE03,CODE04,CODE05
	DB	CODE06,CODE07,CODE08,CODE09,CODE10,CODE11
	DB	CODE12,CODE13,CODE14,CODE15,CODE16,CODE17
	DB	CODE18,CODE19,CODE20,CODE21,CODE22,CODE23
	DB	CODE24,CODE25,CODE26,CODE27,CODE28,CODE29
	DB	CODE30,IGNORE

; TATS[CHLICHE SPRUNGTABELLE F]R GR\SSERE SPRUNGDISTANZEN.

CODE00:	CALL	BELL		; PULS AN GLOCKE AUSGEBEN
IGNORE:	SEL	MB0
	JMP	HLOOP		; UNERKANNTEN CODE IGNORIEREN

CODE01:	JMP	BSP		; BACKSPACE (CURSOR LEFT)
CODE02:	JMP	HZT		; HORIZONTAL-TABULATOR
CODE03:	JMP	LFD		; LINE FEED
CODE04:	JMP	CUP		; CURSOR UP
CODE05:	JMP	CRG		; CURSOR RIGHT
CODE06:	JMP	CAR		; CARRIAGE RETURN
CODE07:	JMP	CDN		; CURSOR DOWN
CODE08:	JMP	FFD		; FORM FEED (PAGE CLEAR)
CODE09:	JMP	HOM		; CURSOR HOME
CODE10:	JMP	CATTST		; CURSOR ATTRIBUT SETZEN
CODE11:	JMP	CURSET		; CURSOR SETZEN (ROW,COLUMN)
CODE12:	JMP	CURASK		; CURSORPOSITION AUSGEBEN (R,C)
CODE13:	JMP	SETMOD		; SET LOCAL/FDX/HDX MODE
CODE14:	JMP	CHRINS		; CHARACTER INSERT
CODE15:	JMP	CHRDEL		; CHARACTER DELETE
CODE16:	JMP	LININS		; LINE INSERT
CODE17:	JMP	LINDEL		; LINE DELETE
CODE18:	JMP	ERAEOL		; ERA TO END OF LINE
CODE19:	JMP	ERAEOS		; ERA TO END OF SCREEN
CODE20:	JMP	NATSET		; ZEICHENSATZ W[HLEN
CODE21:	JMP	HALFON		; HALF INTENSITY ON
CODE22:	JMP	HALFOF		; HALF INTENSITY OFF
CODE23:	JMP	REVON		; REVERSE SCREEN ON
CODE24:	JMP	REVOFF		; REVERSE SCREEN OFF
CODE25:	JMP	ATTSET		; VIDEO-ATTRIBUTE SETZEN
CODE26:	JMP	CTLON		; CONTROL MODE ON
CODE27:	JMP	BAKTAB		; BACK-TAB
CODE28:	JMP	BODSET		; BAUDRATE [NDERN
CODE29:	JMP	SETCLK		; UHR STELLEN
CODE30:	JMP	ASKCLK		; UHR ABFRAGEN

; TRANSFORMATIONSTABELLEN F]R CONTROL-CODES.

TV950C: DB	7,0,8,1,9,2,0AH,3,0BH,4,0CH,5,0DH,6,16H,7
	DB	1AH,8,1EH,9,0

; TRANSFORMATIONSTABELLEN F]R ESCAPE-CODES.

TV950E: DB	'.',10,'=',11,'?',12,'D',13,'Q',14,'W',15,'E',16
	DB	'R',17,'T',18,'t',18,'Y',19,'y',19,'z',20,')',21
	DB	'(',22,'b',23,'d',24,'G',25,'U',26,'+',8,'*',8
	DB	';',8,':',8,',',8,'I',27,'{',28,'m',29,'n',30,0

GETTR:	MOVP	A,@A		; ZEICHEN AUS TABELLE
	RET			; UND ZUR]CK

; CATTST SETZT CURSOR-ATTRIBUTE, VER[NDERT AUCH REG4.

CATTST:	SEL	MB0		; ALLE CALL/JUMP IN BANK 0 !
	CALL	CI		; WERT HOLEN
	MOV	A,R3
	ADD	A,#-'0'		; OFFSET SUBTRAHIEREN
	JZ	CATTS1		; ATTR. 0 : CURSOR OFF
	JNC	CATTSX		; WERT ZU KLEIN
	MOV	R3,A		; NORMIERT NACH R3
	ADD	A,#-5
	JC	CATTSX		; WERT ZU GROSS
	MOV	R1,#REG4
	MOV	A,R3		; NORMIERTES ATTRIBUT
	DEC	A
	XRL	A,#2		; BLOCK/STRICH TAUSCHEN
	RL	A		; NACH LINKS F]R REG4
	MOV	R2,A
	MOV	A,@R1		; REG4 LESEN
	ANL	A,#0F9H		; CURS.ATTR. WEGBLENDEN
	ORL	A,R2		; NEUE WERTE EINSETZEN
	MOV	@R1,A		; REG4 ABSPEICHERN
	MOV	A,R7		; BOOLEAN FLAG
	ANL	A,#0F7H		; CUROFF R]CKSETZEN
	MOV	R7,A
	CALL	INIT		; NEU INIT.
CATTSX:	JMP	HLOOP

CATTS1:	MOV	A,R7		; BOOLEAN FLAG
	ORL	A,#8		; CURSOR OFF
	MOV	R7,A
	CALL	INIT		; NEU INIT.
	JMP	HLOOP

; CNORM NORMIERT ASCII-ANGABEN F]R CURSORPOSITIONIERUNG.
; R1 MUSS AUF SPEICHERZELLE MIT MAXIMALWERT ZEIGEN.

CNORM:	MOV	A,R3		; WERT ALS ASCII-ZEICHEN
	ADD	A,#-' '		; OFFSET SUBTRAHIEREN
	JNC	CNORM1		; < 0 : MIT 0 ZUR]CK
	MOV	R3,A		; NORMIERT NACH R3
	CPL	A
	ADD	A,@R1		; ]BER MAXIMALWERT ?
	JNC	CNORM2
	MOV	A,R3		; SONST WERT UNVER[NDERT
	RET
CNORM1:	CLR	A
	RET			; MIT WERT 0 ZUR]CK (MINIMUM)
CNORM2:	MOV	A,@R1		; BEGRENZEN AUF MAXIMUM
	DEC	A
	RET

; CURSET SETZT CURSOR AN DIREKT ANGEGEBENE STELLE.

CURSET:	SEL	MB0
	CALL	CI		; ZEILE
	SEL	MB2
	MOV	R1,#ROWNUM	; MAXIMUM
	CALL	CNORM		; NORMIEREN
	MOV	R4,A		; ZEILE-1 IN R4
	INC	A
	MOV	R5,A		; NEUE ZEILE
	SEL	MB0
	CALL	CI		; SPALTE
	SEL	MB2
	MOV	R1,#ROWLEN	; MAXIMUM
	MOV	A,@R1
	MOV	R2,A		; L[NGE NACH R2 F]R LNFEED
	CALL	CNORM
	INC	A
	MOV	R6,A		; SPALTE
	MOV	A,HOME
	MOV	CURS,A		; CURSOR AUF HOME-POSITION
	MOV	A,R4
	JZ	COLSET		; ZEILE 1 : DIREKT SPALTE SETZEN
ROWSET:	CALL	LNFEED		; ZEILENVORSCHUB
	DJNZ	R4,ROWSET
COLSET:	MOV	A,CURS
	ADD	A,R6		; SPALTE ADDIEREN
	DEC	A		; SPALTE AB 1 GEZ[HLT
	MOV	CURS,A
	SEL	MB0
	JMP	HLOOP

; CURASK GIBT AUGENBLICKLICHE CURSORPOSITION AN HOST.

CURASK:	MOV	A,R5		; ZEILE
	ADD	A,#' '-1	; ASCII-OFFSET
	MOV	R3,A
	SEL	MB0
	CALL	CO		; AUSGEBEN
	MOV	A,R6		; SPALTE
	ADD	A,#' '-1
	MOV	R3,A
	CALL	CO		; AUSGEBEN
	MOV	R3,#CR
	CALL	CO		; CARRIAGE RETURN ALS ABSCHLUSS
CURASX:	SEL	MB0
	JMP	HLOOP

; LOCAL-MODUS SETZEN (ESC D L). WENN 2.BYTE NICHT L IST, WIRD
; NORMALER ONLINE-MODE EINGESTELLT.

SETMOD:	SEL	MB0
	CALL	CI		; N[CHSTEN BUCHSTABEN HOLEN
	SEL	MB2
	MOV	A,R3
	XRL	A,#'L'		; LOCAL ?
	JNZ	SETMD1
	MOV	A,R7		; BOOLEAN FLAG
	ORL	A,#1		; LOCAL SETZEN
	JMP	SETMDX
SETMD1:	MOV	A,R7		; BOOLEAN FLAG
	ANL	A,#0FEH		; LOCAL R]CKSETZEN
SETMDX:	MOV	R7,A
	CALL	STMODE		; STATUSZEILE !
	SEL	MB0
	JMP	HLOOP

; CHARACTER INSERT. AN DER CURSORPOSITION WIRD EIN SPACE
; EINGEF]GT, ALLE WEITEREN ZEICHEN WERDEN NACH RECHTS GESCHOBEN.

CHRINS:	MOV	R1,#ROWLEN
	MOV	A,R6		; SPALTE
	CPL	A
	INC	A		; -SPALTE
	ADD	A,@R1		; ROWLEN-SPALTE
	JZ	CINSX		; ANZAHL 0: SPC EINSETZEN
	MOV	R2,A		; ANZAHL NACH R2
	MOV	A,CURS
	ADD	A,R2		; LETZTE STELLE DER ZEILE
	MOVL	R1,A		; R1 : ZIEL
	DEC	A
	MOVL	R0,A		; R0 : QUELLE
CINS1:	MOVX	A,@R0
	MOVX	@R1,A		; MOVE
	DECL	R0
	DECL	R1
	DJNZ	R2,CINS1
CINSX:	MOVX	A,@CURS		; ZEICHEN LESEN (ATTRIBUTE!)
	MOV	A,#' '
	MOVX	@CURS,A		; AN CURSORPOS. SPACE
	SEL	MB0
	JMP	HLOOP

; CHARACTER DELETE. ALLE ZEICHEN RECHTS DES CURSORS WERDEN
; UM EINEN PLATZ NACH LINKS VERSCHOBEN.

CHRDEL:	MOV	R1,#ROWLEN
	MOV	A,R6
	CPL	A
	INC	A		; -SPALTE
	ADD	A,@R1		; ROWLEN-SPALTE
	JNZ	CDEL9
	JMP	CINSX		; BEI ANZAHL 0 SPC EINS.
CDEL9:	MOV	R2,A		; ANZAHL
	MOV	A,CURS
	MOVL	R1,A		; R1 : ZIEL
	INC	A
	MOVL	R0,A		; R0 : QUELLE
CDEL1:	MOVX	A,@R0
	MOVX	@R1,A		; MOVE
	INCL	R0
	INCL	R1
	DJNZ	R2,CDEL1
	MOV	A,#' '		; SPACE (ATTRIBUTE UNVER[ND.)
	MOVX	@R1,A		; DAHINTER SPACE
	SEL	MB0
	JMP	HLOOP

; LNFEED BEWIRKT CURSORVERSCHIEBUNG NACH UNTEN, DIE ZEILENL[NGE
; MUSS IN R2 ENTHALTEN SEIN. DER CURSOR MUSS AUF EINEM ZEILEN-
; ANFANG STEHEN !

LNFEED:	MOV	A,CURS
	ADD	A,R2
	MOV	CURS,A		; CURSOR 1 ZEILE WEITER
	CALL	EODCHK		; SPEICHERENDE ?
	JNC	LNFDX
	CLR	A
	MOV	HACC,A
	MOV	CURS,A		; BEI BILDENDE WIEDER AUF 0
LNFDX:	RET

; CURSUP BEWIRKT CURSORVERSCHIEBUNG 1 ZEILE NACH OBEN. ZEILEN-
; L[NGE IN R2, CURSOR MUSS AUF ZEILENANFANG STEHEN.

CURSUP:	MOV	A,R2
	MOV	R3,A		; ZEILENL[NGE
CURSU1:	DEC	CURS
	DJNZ	R3,CURSU1	; CURSOR 1 ZEILE H\HER
	MOV	A,CURS
	CALL	TODCHK		; OB. SPEICHERENDE ?
	JNC	CURSUX		; RETURN
	MOV	R0,#ENDHI
	MOV	A,@R0
	DEC	A		; HACC 1 ZU NIEDRIG !
	MOV	HACC,A
	DEC	R0
	MOV	A,R2		; ZEILENL[NGE
	CPL	A
	INC	A
	ADD	A,@R0		; ADRESSE DES ZEILENANFANGS
	MOV	CURS,A
CURSUX:	RET

; CONTROL MODE ON.

CTLON:	MOV	A,R7
	ORL	A,#2		; BOOLEAN FLAG BIT 1 SETZEN
	MOV	R7,A		; R7 SPEICHERN, STATUSZ. ANZ.
	CALL	STCTL		; NEUEN STATUS ANZEIGEN
	SEL	MB0
	JMP	HLOOP

; LINE INSERT. DIE CURSORZEILE WIRD NACH UNTEN GESCHOBEN,
; ES WIRD EINE NEUE LEERZEILE EINGESETZT.

LININS:	DEC	CURS
	DJNZ	R6,LININS	; CARRIAGE RETURN
	INC	CURS
	MOV	R1,#ROWLEN
	MOV	A,@R1
	MOV	R2,A		; ZEILENL[NGE IN R2
	INC	R1		; -> ROWNUM
	MOV	A,R5		; ZEILE
	CPL	A		; -ZEILE-1
	INC	A
	ADD	A,@R1		; ROWNUM-ZEILE
	JNZ	LINS9
	JMP	CURDEL		; 0 : CURSORZEILE L\SCHEN
LINS9:	MOV	R6,A
	INC	A
	MOV	R4,A
LINS1:	CALL	LNFEED		; EINE ZEILE WEITER
	DJNZ	R6,LINS1	; AUF LETZTE ZEILE
	JMP	LINS4		; POINTER SETZEN USW
LINS2:	MOV	A,R2
	MOV	R3,A		; R3 Z[HLER INNERE SCHLEIFE
LINS3:	MOVX	A,@R0
	MOVX	@R1,A
	INCL	R0
	INCL	R1
	DJNZ	R3,LINS3	; ZEILE NACH UNTEN VERSCHIEBEN
LINS4:	MOV	A,CURS		; VORIGE QUELLZEILE
	MOVL	R1,A		; JETZIGE ZIELZEILE
	CALL	CURSUP		; CURSOR 1 ZEILE H\HER
	MOV	A,CURS		; JETZIGE CURSORZEILE
	MOVL	R0,A		; NEUE QUELLZEILE
	DJNZ	R4,LINS2	; DAS GANZE F]R ALLE ZEILEN
	CALL	LNFEED		; CURSOR WIEDER 1 RUNTER
	MOV	A,CURS
	CALL	CLRLIN		; CURSORZEILE L\SCHEN
LINSX:	MOV	R6,#1		; SPALTE 1
	SEL	MB0
	JMP	HLOOP

; LINE DELETE. DIE AKTUELLE CURSORZEILE WIRD GEL\SCHT, ALLE
; WEITEREN R]CKEN VON UNTEN NACH.

LINDEL:	DEC	CURS
	DJNZ	R6,LINDEL	; CARRIAGE RETURN
	INC	CURS
	MOV	R1,#ROWLEN
	MOV	A,@R1
	MOV	R2,A		; ZEILENL[NGE NACH R2
	INC	R1
	MOV	A,R5		; ZEILE
	CPL	A
	INC	A		; -ZEILE
	ADD	A,@R1		; ROWNUM-ZEILE = ANZAHL
	JZ	CURDEL		; 0 : NUR CURSORZEILE L\SCHEN
	MOV	R4,A
	MOV	R6,A
LDEL1:	MOV	A,CURS
	MOVL	R0,A		; ZIELZEILE
	CALL	LNFEED
	MOV	A,CURS
	MOVL	R1,A		; QUELLZEILE
	MOV	A,R2
	MOV	R3,A		; ANZAHL
LDEL2:	MOVX	A,@R1
	MOVX	@R0,A
	INCL	R0
	INCL	R1
	DJNZ	R3,LDEL2	; MOVE
	DJNZ	R4,LDEL1	; F]R ALLE ZEILEN
	MOV	A,CURS
	CALL	CLRLIN		; UNTERSTE ZEILE L\SCHEN
	MOV	A,@R1
	MOV	R2,A		; ZEILENL[NGE WIEDER NACH R2
LDEL3:	CALL	CURSUP
	DJNZ	R6,LDEL3	; CURSOR WIEDER NACH OBEN
	JMP	LINSX		; SPALTE 1, RETURN

CURDEL:	MOV	A,CURS
	CALL	CLRLIN		; CURSORZEILE L\SCHEN
	JMP	LINSX		; SPALTE 1, RETURN

; ERAEOL L\SCHT AKTUELLE ZEILE VON CURSORPOSITION BIS ENDE.

ERAEOL:	MOV	R1,#ROWLEN
	MOV	A,R6		; SPALTE
	CPL	A
	INC	A
	ADD	A,@R1		; ROWLEN-SPALTE
	INC	A		; ANZAHL, MIN. 1
	MOV	R2,A
	MOV	A,CURS
	MOVL	R0,A		; NACH R0 F]R CLRLIN
	CALL	CLRLN0		; REST DER ZEILE L\SCHEN
	SEL	MB0
	JMP	HLOOP

; ERAEOS L\SCHT AKTUELLE SEITE VON CURSORPOSITION BIS ENDE.

ERAEOS:	MOV	R1,#ROWLEN
	MOV	A,R6		; SPALTE
	CPL	A
	INC	A
	ADD	A,@R1		; ROWLEN-SPALTE
	INC	A		; ANZAHL
	MOV	R2,A
	MOV	A,CURS
	MOVL	R0,A		; NACH R0 F]R CLRLIN
	CALL	CLRLN0		; REST DER ZEILE L\SCHEN
	MOV	A,@R1
	MOV	R2,A		; ZEILENL[NGE NACH R2
	INC	R1
	MOV	A,R5		; ZEILE
	CPL	A
	INC	A
	ADD	A,@R1		; ROWNUM-ZEILE = ANZAHL
	JZ	EOSX
	MOV	R4,A
	MOV	A,CURS
	MOVL	R0,A		; ALTE CURSORPOS. RETTEN
	MOV	A,R6
	MOV	R3,A		; ANZAHL F]R CR
EOS1:	DEC	CURS
	DJNZ	R3,EOS1		; CARRIAGE RETURN
	INC	CURS		; KORREKTUR WEIL 1 ZUVIEL
EOS2:	CALL	LNFEED		; EINE ZEILE WEITER
	MOV	A,CURS
	MOVL	R1,A
	MOV	A,R2
	MOV	R3,A		; L[NGE NACH R3
	MOV	A,#0FFH		; KEINE ATTRIBUTE
	MOV	HACC,A
	MOV	A,#' '		; BLANK
EOS3:	MOVX	@R1,A
	INCL	R1
	DJNZ	R3,EOS3		; GANZE ZEILE L\SCHEN
	DJNZ	R4,EOS2		; ALLE UNTEREN ZEILEN
	MOVL	A,R0
	MOV	CURS,A		; ALTE CURSORPOSITION
EOSX:	SEL	MB0
	JMP	HLOOP

; NATSET SCHALTET AUF NEUEN ZEICHENSATZ UM.

NATSET:	SEL	MB0
	CALL	CI		; ARGUMENT
	SEL	MB2
	MOV	A,R3
	ADD	A,#-'0'		; OFFSET SUBTRAHIEREN
	JNC	EOSX		; WERT ZU KLEIN
	MOV	R3,A
	ADD	A,#-8
	JC	EOSX		; WERT ZU GROSS
	MOV	A,R3
	RL	A
	MOV	R3,A
	MOV	R1,#REG5
	MOV	A,@R1		; REG5
	ANL	A,#0F1H		; NATVAR AUSBLENDEN
	ORL	A,R3		; NEUEN ZEICHENSATZ EINSETZEN
SETBAK:	MOV	@R1,A		; REG5 SPEICHERN
	SEL	MB0
	CALL	INIT		; NEU INITIALISIEREN
	SEL	MB2
	CALL	STSET		; NATIONALIT[T ANZEIGEN
NATSTX:	SEL	MB0
	JMP	HLOOP

; ATTRIBUTE SETZEN : HALF INTENSITY ON/OFF.

HALFON:	MOV	R1,#CURATT	; CURRENT ATTRIBUTE
	MOV	A,@R1
	ANL	A,#0FDH		; HALF INTENSITY SETZEN
	MOV	@R1,A
	SEL	MB0
	JMP	HLOOP

HALFOF:	MOV	R1,#CURATT
	MOV	A,@R1
	ORL	A,#2		; HALF INTENSITY L\SCHEN
	MOV	@R1,A
	SEL	MB0
	JMP	HLOOP

; GANZER SCHIRM REVERSE VIDEO / NORMAL VIDEO.

REVON:	MOV	R1,#REG4
	MOV	A,@R1
	ORL	A,#8		; SET REVERSE VIDEO
	JMP	SETBAK		; NEU INIT, HLOOP

REVOFF:	MOV	R1,#REG4
	MOV	A,@R1
	ANL	A,#0F7H		; SET NORMAL VIDEO
	JMP	SETBAK		; NEU INIT, HLOOP
	
; ATTSET SETZT ZEICHENATTRIBUTE ('CURATT'). DIR ATTRIBUTE
; WERDEN CODIERT IN EINEM ASCII-ZEICHEN AB 30H ('0') ]BERGEBEN.
; NACH SUBTRAKTION DIESES WERTES GELTEN DIE FOLGENDEN REGELN :
; BIT 0 GESETZT : BLANK
; BIT 1 GESETZT : BLINK
; BIT 2 GESETZT : REVERSE VIDEO
; BIT 3 GESETZT : UNDERLINE
; BIT 4 GESETZT : DOUBLE WIDTH
; BIT 5 GESETZT : DOUBLE HEIGHT
; BIT 6 GESETZT : GRAPHICS
; IN DEN MODI DOUBLE WIDTH/HEIGHT WERDEN AUTOMATISCH DIE ZEICHEN
; NACH RECHTS BZW. OBEN EXPANDIERT !
; DAS HALF-INTENSITY-ATTRIBUT WIRD NICHT VER[NDERT.

ATTSET:	SEL	MB0
	CALL	CI		; ARGUMENT
	SEL	MB2
	MOV	R1,#CURATT
	MOV	A,@R1		; ALTEN WERT HOLEN
	ORL	A,#0FDH		; NUR HALF INTEN BLEIBT
	MOV	R4,A		; NACH R4
	MOV	A,R3		; ZEICHEN (ARGUMENT)
	ADD	A,#-'0'		; OFFSET SUBTRAHIEREN
	MOV	R2,#7		; Z[HLER
ATTST1:	RRC	A		; RECHTES BIT INS CARRY
	JNC	ATTST2		; FALLS BIT=0, TEIL ]BERSPR.
	MOV	R3,A		; ACCU RETTEN
	MOV	A,#LOW(VATTAB-1)
	ADD	A,R2		; ZEIGER AUF BITZUORDNUNG
	MOVP	A,@A
	ANL	A,R4		; ENTSPR. BIT R]CKSETZEN
	MOV	R4,A
	MOV	A,R3		; ACCU WIEDERHOLEN
ATTST2:	DJNZ	R2,ATTST1	; F]R ALLE 7 BIT
	MOV	A,R4
	MOV	@R1,A		; NEUE ATTRIBUTE ABSPEICHERN
	SEL	MB0
	JMP	HLOOP

VATTAB:	DB	7FH,0F7H,0EFH,0DFH,0FEH,0FBH,0BFH

; BACK-TAB.

BAKTAB:	CALL	CLEFT		; CURSOR NACH LINKS
	MOV	A,R6		; SPALTE
	DEC	A		; AB 0
	ANL	A,#7
	JNZ	BAKTAB		; BIS AUF TAB-SPALTE
	SEL	MB0
BAKTBX:	JMP	HLOOP

; BAUDRATE UND KOMMUNIKATIONSPARAMETER NACHTR[GLICH [NDERN.

BODSET:	SEL	MB0		; ALLE CALL'S NACH MB0
	CALL	CI		; 1. PARAMETER: BAUD RATE
	MOV	A,R3
	ANL	A,#0FH		; UNTERES NIBBLE G]LTIG
	JNZ	BODST1
	MOV	A,#14		; 0 : 9600 BD
BODST1:	ADD	A,#-3		; UMRECHNEN, 50 UND 75 WEG
	JNC	BAKTBX		; 50 BZW. 75 : IGNORIEREN
	SWAP	A		; -> HIGH NIBBLE
	MOV	R4,A
	CALL	CI		; 2. PARAMETER: STOP BITS
	MOV	A,R3
	ANL	A,#1		; 1 G]LTIGES BIT
	ORL	A,R4
	MOV	R4,A		; EINSETZEN
	CALL	CI		; 3. PARAMETER: PARITY
	MOV	A,R3
	ANL	A,#7		; 3 BIT G]LTIG
	RL	A
	ORL	A,R4		; EINSETZEN
	MOV	R1,#REG6
	MOV	@R1,A		; NEUER WERT VON REG6
	CALL	CI		; 4. PARAMETER: WORD LENGTH
	MOV	A,R3
	CPL	A		; POLARIT[T ANDERS
	ANL	A,#1		; 1 G]LTIGES BIT
	MOV	R3,A
	MOV	R1,#REG5
	MOV	A,@R1		; ALTER WERT REG5
	ANL	A,#0FEH
	ORL	A,R3
	MOV	@R1,A		; NEUER WERT REG5
	CALL	INIT		; ENTSPRECHEND INIT.
	SEL	MB2
	CALL	STSET		; STATUSZEILE [NDERN
	SEL	MB0
	JMP	HLOOP		; ZUR]CK ZUR HAUPTSCHLEIFE

; UHR IN STATUSZEILE SETZEN BZW. ABFRAGEN.
; DATENFORMAT: HMS BCD MIT OFFSET 20H (' ').

SETCLK:	SEL	MB0		; ALLE CALLS IN BASIS-TEIL
	CALL	CI
	MOV	A,R3		; STUNDEN-BYTE
	ADD	A,#-' '
	MOV	R4,A		; BCD NACH R4
	CALL	CI
	MOV	A,R3		; MINUTEN-BYTE
	ADD	A,#-' '
	MOV	R2,A		; BCD NACH R2
	CALL	CI
	MOV	A,R3		; SEKUNDEN-BYTE
	ADD	A,#-' '
	MOV	R0,#SECOND	; ZEIGER AUF UHREN-RAM
	DIS	II		; KEINE RT-INTERRUPTS!
	MOV	@R0,A		; SEKUNDEN SETZEN
	DEC	R0
	MOV	A,R2
	MOV	@R0,A		; MINUTEN SETZEN
	DEC	R0
	MOV	A,R4
	MOV	@R0,A		; STUNDEN SETZEN
	EN	II
	JMP	HLOOP

ASKCLK:	SEL	MB0		; ALLE CALLS IN BASIS-TEIL
	MOV	R0,#HOUR	; ZEIGER AUF UHREN-RAM
	MOV	R4,#3		; 3 BYTE AUSZUGEBEN
ASKCK1:	MOV	A,@R0
	ADD	A,#' '		; OFFSET ADDIEREN
	MOV	R3,A
	CALL	CO		; BYTE AUSGEBEN
	INC	R0
	DJNZ	R4,ASKCK1	; ALLE 3 BYTE (HMS) SENDEN
	MOV	R3,#CR
	CALL	CO		; ABSCHLUSS MIT CR
	JMP	HLOOP

	END

