; EQUATES.ASM F]R C'T-TEXT-TERMINAL, STAND 26.07.89 TR
; BEDINGUNGEN BEIM ASSEMBLIEREN (SWITCHES) :

Z15600	EQU	0		; 12 MHZ / 15600 HZ
Z16650	EQU	0		; 12 MHZ / 16650 HZ
Z17300	EQU	0		; 18 MHZ / 17300 HZ
Z17550	EQU	0		; 18 MHZ / 17550 HZ
Z17850	EQU	1		; 18 MHZ / 17850 HZ
Z18400	EQU	0		; 18 MHZ / 18400 HZ
Z20820	EQU	0		; 18 MHZ / 20820 HZ / 60 HZ
MHZ12	EQU	Z15600 OR Z16650
MHZ18	EQU	Z17300 OR Z17550 OR Z17850 OR Z18400 OR Z20820

; BETRIEB MIT 12 MHZ:
; BEI 15600 HZ ALLE BILDFORMATE M\GLICH
; BEI 16650 HZ 28 ZEILEN OHNE STATUSZEILE
; BETRIEB MIT 18 MHZ: 
; BEI 17300 HZ MAX. 92 X 27 (OHNE STATUSZEILE)
; BEI 17550 HZ MAX. 27 ZEILEN (OHNE STATUSZEILE)
; BEI 17850 HZ 28 ZEILEN OHNE STATUSZEILE 
; BEI 18400 HZ ALLE BILDFORMATE M\GLICH
; BEI 20820 HZ MAX. 80 X 27 (OHNE STATUSZEILE)

; BESONDERE TASTENFUNKTIONEN :

LKEY	EQU	00H		; CODE F]R LOCAL-MODUS
SKEY	EQU	1FH		; CODE F]R SETUP-MODUS
UKEY	EQU	05H		; CODE F]R CURSOR-UP (^E)
DKEY	EQU	18H		; CODE F]R CURSOR-DOWN (^X)
CKEY	EQU	20H		; CODE F]R SETUP-WECHSEL (' ')

; AUSGABE-PARALLELPORT :

DTR	EQU	80H		; DATA TERMINAL READY (AKT. L)
BELBIT	EQU	20H		; BELL-IMPULS (AKT. L->H)

; ASCII CHARACTER :

CR	EQU	0DH		; CARRIAGE RETURN CHARACTER
ESC	EQU	1BH		; ESCAPE CHARACTER
XOFFC	EQU	'S'-40H		; XOFF CHARACTER (STOP V.24)
XONC	EQU	'Q'-40H		; XON CHARACTER (CONT. V.24)

; BELEGUNG DES INTERNEN RAM (64 BYTE):
; 00..07 REGISTER BANK 0
; 08..15 STACK (7 EBENEN)
; 18..1F REGISTER BANK 1
WRPTR	EQU	16H	; SCHREIBZEIGER F]R RING
RDPTR	EQU	17H	; LESEZEIGER F]R RING
RING	EQU	20H	; 16 BYTE RINGPUFFER F]R EMPFANG
RNGEND	EQU	2FH	; ENDE DES PUFFERS ALS MASKE
BFLAG2	EQU	30H	; BOOLEAN FLAG NO. 2
TBUFF	EQU	31H	; TASTENPUFFER (1 ZEICHEN)
CURATT	EQU	32H	; AKTUELLE ATTRIBUTE
MASK7	EQU	33H	; ATTRIBUTE F]R GESETZTES BIT 7
ROWLEN	EQU	34H	; ZEILENL[NGE 
ROWNUM	EQU	35H	; ZEILENANZAHL
ENDLO	EQU	36H	; ENDADRESSE DES DISPLAY-RAM (LOW)
ENDHI	EQU	37H	; ENDADRESSE DES DISPLAY-RAM (HIGH)
REG4	EQU	38H	; KOPIE VON SWITCH 4
REG5	EQU	39H	; KOPIE VON SWITCH 5
REG6	EQU	3AH	; KOPIE VON SWITCH 6
NATTAB	EQU	3BH	; TAB.ADR. DES AKT. ZEICHENSATZES
HOUR	EQU	3CH	; UHR: STUNDEN (BCD)
MINUTE	EQU	3DH	; UHR: MINUTEN (BCD)
SECOND	EQU	3EH	; UHR: SEKUNDEN (BCD)

; ZUSAMMENSETZUNG DER BETRIEBSPROGRAMM-MODULE:
; 0000-07FF	TBASE		ALLG. ROUTINEN
; 0800-0FFF	SETUP		SETUP-MEN]
; 1000-17FF	TV950		TERMINAL-EMULATION
;
; DIESES BETRIEBSPROGRAMM F]R DEN TMP NS455 SETZT DIE FOLGENDE
; BESCHALTUNG VORAUS:
;
; QUARZFREQUENZ 12 ODER 18 MHZ
; ES WIRD DAVON AUSGEGANGEN, DASS BEI 12 MHZ TAKT DIE A-MATRIX
; (NS405A12 MIT 5X7-MATRIX) UND BEI 18 MHZ TAKT DIE B-MATRIX
; (NS405B18 MIT 7X9-MATRIX) VERWENDET WIRD.
;
; SPEICHERBELEGUNG DES SYSTEM-BUS:
; 0000-1FFF	8192 X 16 BIT RAM (DISPLAY, SETUP)
;    8000	DIP-SWITCH F]R DIV. TERMINAL-EINSTELLUNGEN
;    A000	DIP-SWITCH TERMINAL-EIGENSCHAFTEN
;    C000	DIP-SWITCH KOMMUNIKATION
;
; ALS DISPLAY-RAM REICHEN BEI ANWENDUNGEN OHNE SETUP-MEN] AUCH
; KLEINERE RAM'S AUS (2048 X 16). HIERZU MUSS DER SCHALTER
; 'RAMSIZ' (0 VON SWITCH 4) AUF 0 GESETZT WERDEN. ACHTUNG !
; DIE GR\SSEREN FORMATE D]RFEN DANN NICHT MEHR BENUTZT WERDEN !
; FOLGENDE BEDINGUNG MUSS IMMER ERF]LLT SEIN (BEI 2K RAM) :
; COLNUM * (ROWNUM+1) <= 2048 .
;
; BELEGUNG DER DIP-SWITCHES:
;
; 8000 (SWITCH 4) :  	  7   6   5   4   3   2   1   0
;		      	,---,---,---,---,---,---,---,---,
;		      	:STA:NO :XON:SER:REV:CMO:CBL:RAM:
;			:TUS:USE:   :PAR:VID: DE:INK:SIZ:
;			`---'---'---'---'---'---'---'---'
;
;	STATUS:		0 = KEINE STATUSZ.  1 = STATUSZEILE
;	XON:		0 = DTR             1 = XON/XOFF HANDSH.
;	SERPAR:		0 = PAR. TASTATUR   1 = SER. IBM-TAST.
;	REVVID:		0 = NORMAL          1 = REVERSE VIDEO
;	CMODE:		0 = UNTERSTRICH     1 = BLOCK
;	CBLINK:		0 = BLINKEND        1 = STEHEND
;	RAMSIZ:		0 = 2K x 16 RAM     1 = 8K x 16 RAM
;
; A000 (SWITCH 5) :  	  7   6   5   4   3   2   1   0
;		      	,---,---,---,---,---,---,---,---,
;		      	:  COL  :  ROW  : NAT VAR   :WRD:
;			:  NUM  :  NUM  : CHARGEN   :LEN:
;			`---'---'---'---'---'---'---'---'
;
;	COLNUM:		00 = 72, 01 = 80, 10 = 88, 11 = 96
;	ROWNUM:		00 = 22, 01 = 24, 10 = 26, 11 = 28
;			EVENTUELL 28 ZEILEN NICHT M\GLICH !
;	NAT VAR:	ZEICHENSATZ :
;			000 = USA   	  100 = D[NEMARK
;			001 = FRANKREICH  101 = SCHWEDEN
;			010 = DEUTSCHLAND 110 = ITALIEN
;			011 = ENGLAND     111 = SPANIEN
;	WRDLEN:		WORTL[NGE V.24 : 0 = 7 BIT, 1 = 8 BIT
;
; C000 (SWITCH 6) :  	  7   6   5   4   3   2   1   0
;		      	,---,---,---,---,---,---,---,---,
;		      	:     BAUD      :PARITY :PAR:STP:
;			:      RATE     :SELECT :ENA:BIT:
;			`---'---'---'---'---'---'---'---'
;
;	BAUD RATE:	0000 =   110 BD		1000 =  3600 BD
;			0001 = 134.5 BD		1001 =  4800 BD
;			0010 =   150 BD		1010 =  7200 BD
;			0011 =   300 BD		1011 =  9600 BD
;			0100 =   600 BD		1100 = 19200 BD
;			0101 =  1200 BD		1101 = 19200 BD
;			0110 =  1800 BD		1110 = 19200 BD
;			0111 =  2400 BD		1111 =  9600 BD
;	PARITY SELECT:	00 = ODD		01 = EVEN
;			10 = MARK		11 = SPACE
;	PARENA:		0 = PARITY DISABLE	1 = ENABLE
;	STPBIT:		0 = 1 STOP BIT		1 = 2 STOP BITS
;
; BOOLEAN FLAG (RB0-R7) : 7   6   5   4   3   2   1   0
;		      	,---,---,---,---,---,---,---,---,
;		      	:NO :TFL:HDS:NO :CUR:SET:CTL:LOC:
;			:USE: AG:AKT:USE:OFF: UP:MOD: AL:
;			`---'---'---'---'---'---'---'---'
;
;	TFLAG:		1 = TASTENPUFFER GEF]LLT
;	HDSAKT:		1 = HANDSHAKE AKTIV (V.24 STOPPED)
;	CUROFF:		1 = CURSOR OFF (ATTRIBUT 0)
;	SETUP:		1 = SETUP MODE AKTIV
;	CTLMOD:		1 = CONTROL MODE AKTIV
;	LOCAL:		1 = LOCAL MODE AKTIV
;
; BFLAG2 (RAM 30H, NUR BEI SERIELLER IBM-TASTATUR) :
;			  7   6   5   4   3   2   1   0
;		      	,---,---,---,---,---,---,---,---,
;		      	: RESERVED  :NUM:CAP:ALT:CTL:SHI:
;			:           :LCK:LCK:   :   : FT:
;			`---'---'---'---'---'---'---'---'
;
;	RESERVED:	RESERVIERT F]R TASTENCODE-BEARBEITUNG
;	NUMLCK:		1 = NUM-LOCK AKTIV
;	CAPLCK:		1 = CAPS-LOCK AKTIV
;	ALT:		1 = ALT-TASTE GEDR]CKT
;	CTL:		1 = CTL-TASTE GEDR]CKT
;	SHIFT:		1 = SHIFT-TASTE GEDR]CKT
;
; REGISTERVERWENDUNG : 
;
;          REGISTER BANK 0              REGISTER BANK 1
;       ,-------------------,        ,-------------------,
;       :  POINTER, TEMP    :   R0   :  POINTER, TEMP    :
;       :-------------------:        :-------------------:
;       :  POINTER, TEMP    :   R1   :  POINTER, TEMP    :
;       :-------------------:        :-------------------:
;       :       TEMP        :   R2   :       TEMP        :
;       :-------------------:        :-------------------:
;       :       TEMP        :   R3   :       TEMP        :
;       :-------------------:        :-------------------:
;       :       TEMP        :   R4   :       TEMP        :
;       :-------------------:        :-------------------:
;       : AKTUELLE  ZEILE   :   R5   :  ZW.SP. RB, TEMP  :
;       :-------------------:        :-------------------:
;       : AKTUELLE  SPALTE  :   R6   :  HACC ZW.SPEICHER :
;       :-------------------:        :-------------------:
;       :  BOOLEAN FLAG     :   R7   :  ACCU ZW.SPEICHER :
;       `-------------------'        `-------------------'
;
; F]R INTERRUPTBEARBEITUNG WIRD AUF BANK 1 UMGESCHALTET, DAHER
; DARF SONST IM PROGRAMM BANK 1 NICHT VERWENDET WERDEN.

	END
