	TITLE	'SETUP-MEN] F]R TERMINAL MIT NS405/455'
	SBTTL	"C'T TEXT-TERMINAL SOFTWARE V2.2"
	WIDTH	80
	NOLIST
	INCLUD	EQUATES.ASM
	LIST
	ORG	800H		; BANK 1

; T. REH 24.03.89

; UNTERPROGRAMME IN ANDEREN MODULEN:

INIT	EQU	0AH		; GESAMTINIT. TERMINAL
CI	EQU	0CH		; CONSOLE INPUT IN R3
CO	EQU	0EH		; CONSOLE OUTPUT IN R3
HLOOP	EQU	10H		; HAUPTSCHLEIFE TERMINAL
STSET	EQU	100AH		; STATUSZEILE AUFFRISCHEN
SDISP	EQU	100CH		; AUSGABEROUTINE STATUSZEILE
FFD	EQU	100EH		; SCHIRM L\SCHEN, HLOOP
CLRPG1	EQU	1010H		; TEIL BILDSCHIRM L\SCHEN
LDSEND	EQU	1012H		; BILD-ENDADRESSE NACH A
EDISP	EQU	1014H		; TERMINAL-EMULATION ANZEIGEN
NDISP	EQU	1016H		; NATIONALIT[T ANZEIGEN
BDISP	EQU	1018H		; BAUDRATE ANZEIGEN
CDISP	EQU	101CH		; SPALTENZAHL ANZEIGEN
RDISP	EQU	101EH		; ZEILENZAHL ANZEIGEN

; EINZIGER EINSPRUNG IN DIESES MODUL:
; SETUP-MODUS : MEN] ZUM [NDERN DER TERMINALEINSTELLUNGEN

SETUP:	JMP	SETUP1		; INS SETUP-MEN] EINSPRINGEN

; HILFSROUTINEN F]R SETUP-MEN]. DOWN2 UND UP2 BEWEGEN DEN CURSOR
; JEWEILS AM LINKEN BILDRAND UM 2 ZEILEN NACH OBEN BZW. UNTEN.

DOWN2:	MOV	R1,#ROWLEN
	MOV	A,CURS
	ADD	A,@R1
	ADD	A,@R1		; CURSOR 2 ZEILEN RUNTER
	MOV	CURS,A
	RET

UP2:	MOV	R1,#ROWLEN
	MOV	A,@R1
	ADD	A,@R1		; 2*ROWLEN
	MOV	R1,A
UP21:	DEC	CURS
	DJNZ	R1,UP21		; CURSOR 2 ZEILEN RAUF
	RET

; HILFSROUTINEN ZUR AUSWAHL DER MEN]PUNKTE
; FREVRS SCHALTET FELD (6 ZEICHEN) AUF REVERS, FNORM SCHALTET
; REVERS WIEDER AB.

FREV18:	MOV	A,CURS
	ADD	A,#18		; SPALTE POSITIONIEREN
	JMP	FREVRS
FREV50:	MOV	A,CURS
	ADD	A,#50		; SPALTE POSITIONIEREN
FREVRS:	MOVL	R1,A		; R1 ALS ZEIGER
	MOV	R2,#6		; R2 ALS Z[HLER
FBLOOP:	MOVX	A,@R1		; ZEICHEN HOLEN
	MOV	R0,A		; KOPIE NACH R0 (NUR ZEICHEN)
	MOV	A,HACC		; ATTRIBUTE HOLEN
	ANL	A,#0FEH		; REVERS SETZEN
	MOV	HACC,A		; NEUE ATTRIBUTE
	MOV	A,R0		; ZEICHEN WIEDERHOLEN
	MOVX	@R1,A		; KOMPLETT WIEDER ABSPEICHERN
	INCL	R1
	DJNZ	R2,FBLOOP	; ALLE 6 ZEICHEN
	RET

FNOR18:	MOV	A,CURS
	ADD	A,#18		; SPALTE (19) POS.
	JMP	FNORM
FNOR50:	MOV	A,CURS
	ADD	A,#50		; SPALTE POSITIONIEREN
FNORM:	MOVL	R1,A		; R1 ALS ZEIGER
	MOV	R2,#6		; R2 ALS Z[HLER
FNLOOP:	MOVX	A,@R1		; ZEICHEN HOLEN
	MOV	R0,A		; KOPIE NACH R0 (NUR ZEICHEN)
	MOV	A,HACC		; ATTRIBUTE HOLEN
	ORL	A,#1		; REVERS R]CKSETZEN
	MOV	HACC,A		; NEUE ATTRIBUTE
	MOV	A,R0		; ZEICHEN WIEDERHOLEN
	MOVX	@R1,A		; KOMPLETT WIEDER ABSPEICHERN
	INCL	R1
	DJNZ	R2,FNLOOP	; ALLE 6 ZEICHEN
	RET

; DIE FOLGENDEN ROUTINEN SCHREIBEN DEN AKTUELLEN STAND
; DER PARAMETER IN DIE DAF]R VORGESEHENEN FELDER.

MTMOD:	MOV	R3,#19		; SPALTE-1
	MOV	A,CURS		; ZEILENANFANG
	SEL	MB2
	CALL	EDISP		; EMULATION SCHREIBEN
	SEL	MB1
	RET

MTCOL:	MOV	R3,#22		; SPALTE-1
	MOV	A,CURS		; ZEILENANFANG
	SEL	MB2
	CALL	CDISP		; SPALTENZAHL ANZEIGEN
	SEL	MB1
	RET

MTROW:	MOV	R3,#22		; SPALTE-1
	MOV	A,CURS		; ZEILENANFANG
	SEL	MB2
	CALL	RDISP		; ZEILENZAHL ANZEIGEN
	SEL	MB1
	RET

MTNAT:	MOV	R3,#21		; SPALTE-1
	MOV	A,CURS		; ZEILENANFANG
	SEL	MB2
	CALL	NDISP		; AUSGEBEN
	SEL	MB1
	RET

MTSTAT:	MOV	R1,#REG4
	MOV	A,@R1
	MOV	R2,#LOW(AN)	; R2 VORBELEGEN
	JB7	MTSTAN		; AN ODER AUS ?
	MOV	R2,#LOW(AUS)	; TEXTZEIGER GESETZT
MTSTAN:	MOV	R3,#18		; SPALTE-1
	JMP	MDISP6		; AN ODER AUS

MTCTL:	MOV	R2,#LOW(AN)	; ZEIGER VORBELEGEN
	MOV	A,R7		; BOOLEAN FLAG
	JB1	MTCTL1
	MOV	R2,#LOW(AUS)
MTCTL1:	MOV	R3,#18		; SPALTE-1
	JMP	MDISP6		; AN ODER AUS

MTGRO:	MOV	R1,#REG4
	MOV	A,@R1
	MOV	R2,#LOW(BLOCK)	; R2 VORBELEGEN
	JB2	MTGRO1
	MOV	R2,#LOW(STRICH)
MTGRO1:	MOV	R3,#18		; SPALTE-1
	JMP	MDISP6

MTART:	MOV	R2,#LOW(AUS)	; VORBELEGEN FALLS AUS
	MOV	A,R7		; BOOLEAN FLAG
	JB3	MTART1		; CURSOR AUS
	MOV	R1,#REG4
	MOV	A,@R1
	MOV	R2,#LOW(RUHEND)
	JB1	MTART1		; RUHEND ODER BLINKEND
	MOV	R2,#LOW(BLINK)
MTART1:	MOV	R3,#18
	JMP	MDISP6		; AUSGEBEN

MTREV:	MOV	R1,#REG4	; REVERSE-MODUS AUSGEBEN
	MOV	A,@R1
	MOV	R2,#LOW(HELL)	; VORBELEGEN
	JB3	MTREV1
	MOV	R2,#LOW(DUNKEL)
MTREV1:	MOV	R3,#50		; SPALTE-1
	JMP	MDISP6		; AN BZW. AUS

SRCHAT:	MOV	R1,#MASK7
	MOV	A,@R1		; DERZEITIGE MASK7
	MOV	R3,A
	MOV	R2,#LOW(MTATB1)	; TABELLENZEIGER
	MOV	R4,#4		; Z[HLER
SRCHA1:	MOV	A,R2
	MOVP	A,@A		; VERGLEICHSWERT
	XRL	A,R3		; MIT ISTWERT VERGLEICHEN
	JZ	SRCHAX		; GEFUNDEN
	INC	R2
	DJNZ	R4,SRCHA1	; UND WEITER
	DEC	R2		; ZEIGER AUF 'AUS'
	MOV	@R1,#0FFH	; MASKE AUSSCHALTEN
SRCHAX:	RET

MCHATT:	CALL	SRCHAT		; ALTE MASK7 ERKENNEN
	MOV	A,R2		; ALTE TABELLENADRESSE
	ADD	A,#0-LOW(MTATB1) ; AUF TABELLE BEZIEHEN
	INC	A		; ERH\HEN
	ANL	A,#3		; MASKIEREN
	ADD	A,#LOW(MTATB1)	; POINTER AUF TABELLE
	MOVP	A,@A		; NEUE MASKE
	MOV	@R1,A		; ABSPEICHERN, DANN ANZEIGEN

MTATT:	CALL	SRCHAT		; MASK7 ERKENNEN
MTATT2:	MOV	A,R2
	ADD	A,#4		; AUF ZWEITE TABELLE GEHEN
	MOVP	A,@A		; TEXTZEIGER HOLEN
	MOV	R2,A
	MOV	R3,#50
	JMP	MDISP6

MTATB1:	DB	0FEH,0FBH,0DFH,0FFH
	DB	REVERS,BLINK,UNDERL,AUS

MTWLEN:	MOV	R1,#REG5
	MOV	A,@R1
	MOV	R2,#LOW(BIT8)	; TEXTZEIGER VORBELEGEN
	JB0	MTWL8		; 7/8 BIT ?
	MOV	R2,#LOW(BIT7)
MTWL8:	MOV	R3,#51		; SPALTE-1
	JMP	MDISP5		; 7 BIT / 8 BIT

MTBAUD:	MOV	R3,#51		; SPALTE-1
	MOV	A,CURS		; ZEILENANFANG
	SEL	MB2
	CALL	BDISP		; AUSGEBEN
	SEL	MB1
	RET

MTSTOP:	MOV	R1,#REG6
	MOV	A,@R1
	MOV	R2,#LOW(BIT2)	; ZEIGER VORBELEGEN
	JB0	MTSTP1
	MOV	R2,#LOW(BIT1)
MTSTP1:	MOV	R3,#51		; SPALTE-1
	JMP	MDISP5		; 1 ODER 2 BIT

MTPAR:	MOV	R1,#REG6
	MOV	A,@R1
	MOV	R2,#LOW(AUS+1)	; VORBELEGEN FALLS AUS
	RR	A
	RRC	A		; ENABLE -> CARRY
	JNC	MTPARX		; DISABLE
	ANL	A,#3		; 2 BIT F]R PARITY-MODE
	ADD	A,#LOW(MTPTAB)
	MOVP	A,@A		; ZEIGER HOLEN
	MOV	R2,A
MTPARX:	MOV	R3,#51		; SPALTE 50
	JMP	MDISP5		; AUSGEBEN

MTPTAB:	DB	ODD,EVEN,MARK,SPACE

MTHAND:	MOV	R1,#REG4
	MOV	A,@R1
	MOV	R2,#LOW(XOFF)	; VORBELEGEN
	JB5	MTHDS1
	MOV	R2,#LOW(HARD)
MTHDS1:	MOV	R3,#52		; SPALTE-1
	MOV	R4,#4		; NUR 4 ZEICHEN
	JMP	MDISP		; HARD ODER SOFT

; INPUT DIENT ZUR EINGABE VON STEUERZEICHEN:
; ERKANNT WERDEN UKEY, DKEY UND CKEY. ALLE ANDEREN CODES WERDEN
; IGNORIERT. SETUP-ENDE WIRD IN INTERRUPTROUTINE BEARBEITET. BEI
; GEDR]CKTER CKEY-TASTE IST BEI R]CKKEHR EINE 0 IM ACCU (ZERO).
; ANSONSTEN IST BEI ERKENNUNG VON UKEY DAS FLAG F0 GESETZT,
; WELCHES IN ALLEN ANDEREN F[LLEN 0 IST. BEI SETUP-ENDE ERFOLGT
; SPRUNG ]BER SBACK NACH SETPX.

INPUT:	CLR	F0
INPUT1:	MOV	A,R7		; BOOLEAN FLAG
	CPL	A
	JB2	SBACK		; NICHT MEHR SETUP: ENDE
	JB6	INPUT1		; WARTEN AUF TFLAG
	MOV	A,R7
	ANL	A,#0BFH		; TFLAG R]CKSETZEN
	MOV	R7,A
	MOV	R0,#TBUFF
	MOV	A,@R0
	ADD	A,#-UKEY	; TESTEN AUF ^E (UKEY)
	JNZ	INPUT2		; KEIN ^E
	INC	A		; ZERO-FLAG L\SCHEN
	CPL	F0		; F0 SETZEN
	RET
INPUT2:	ADD	A,#UKEY-DKEY	; TESTEN AUF ^X (DKEY)
	JNZ	INPUT3		; KEIN ^X
	INC	A		; ZERO-FLAG L\SCHEN
	RET
INPUT3:	ADD	A,#DKEY-SKEY	; TESTEN AUF SETUP (SKEY)
	JZ	SBACK		; ZUR]CK ALS TERMINAL
	ADD	A,#SKEY-CKEY	; TESTEN AUF LEERTASTE (CKEY)
	JZ	INPRET		; RETURN MIT ZERO
	JMP	INPUT		; SONST ZEICHEN IGNORIEREN
INPRET:	RET

SBACK:	DIS	II
	DIS	XI		; INTERRUPTS AUS
	MOV	A,PSW
	DEC	A
	MOV	PSW,A		; STACKPOINTER ZUR]CK
	EN	XI
	EN	II		; INTERRUPTS WIEDER AN
	JMP	SETPX		; ZUR]CK ZUR HAUPTSCHLEIFE

; EINSPRUNG F]R SETUP-MEN]. BILD AUFBAUEN UND WERTE ANZEIGEN.

SETUP1:	MOV	A,#1FH
	MOV	HACC,A
	MOV	A,#0FFH		; ACCU AUF SPEICHERENDE (1FFF)
	MOV	ENDD,A		; GLEICHZEITIG DATENENDE
	MOVL	R1,A
	MOV	A,CURS
	MOVX	@R1,A		; CURSOR RETTEN
	DECL	R1
	MOV	A,HOME
	MOVX	@R1,A		; HOME RETTEN
	DECL	R1
	MOV	A,R5
	MOVX	@R1,A		; R5 (ZEILE) RETTEN
	DECL	R1
	MOV	A,R6
	MOVX	@R1,A		; R6 (SPALTE) RETTEN
	MOV	A,#13
	MOV	TCP,A		; TCP AUF CURSOR SIZE
	MOV	A,#0F0H
	MOV	@TCP,A		; CURSOR AUSSCHALTEN
	SEL	MB2
	CALL	LDSEND		; ENDE DES BILDSPEICHERS
	MOV	R1,#ROWLEN
	ADD	A,@R1		; ZEIGER HINTER STATUSZEILE
	MOV	BEGD,A		; DATENANFANG HIER
	CALL	CLRPG1		; -> HOME,CURS; SEITE L\SCHEN
	SEL	MB1
	MOV	R2,#LOW(TITEL)	; TEXT
	MOV	R3,#2		; SPALTE-1
	MOV	R4,#36		; ZEICHENANZAHL
	CALL	MDSP		; SCHREIBEN
	MOV	R1,#ROWLEN
	MOV	A,CURS
	ADD	A,@R1
	MOV	CURS,A		; CURSOR 1 ZEILE NACH UNTEN
	MOV	R2,#LOW(INFO)
	MOV	R3,#2		; SPALTE-1
	MOV	R4,#43		; ANZAHL
	CALL	MDISP		; INFO SCHREIBEN
	CALL	DOWN2		; CURSOR 2 ZEILEN NACH UNTEN
	MOV	R2,#LOW(MTERM)	; TEXT
	MOV	R3,#9		; SPALTE-1
	MOV	R4,#8		; 8 ZEICHEN
	CALL	MDSP
	MOV	R2,#LOW(MVID)	; TEXT
	MOV	R3,#42		; SPALTE-1
	MOV	R4,#5		; 5 ZEICHEN
	CALL	MDSP
	CALL	DOWN2		; CURSOR 2 AB
	MOV	R2,#LOW(MEMU)
	MOV	R3,#2		; SPALTE-1
	MOV	R4,#9
	CALL	MDSP		; 'EMULATION'
	CALL	MTMOD		; TERMINAL-MODE AUSGEBEN
	MOV	R2,#LOW(MREV)
	MOV	R3,#34		; SPALTE-1
	MOV	R4,#11
	CALL	MDISP		; 'HINTERGRUND'
	CALL	MTREV		; AN BZW AUS AUSGEBEN
	CALL	DOWN2		; 2 ZEILEN WEITER
	MOV	R2,#LOW(MSPA)
	MOV	R3,#2		; SPALTE-1
	MOV	R4,#7
	CALL	MDSP		; 'SPALTEN'
	CALL	MTCOL		; SPALTENZAHL AUSGEBEN
	MOV	R2,#LOW(MATTR)
	MOV	R3,#34		; SPALTE-1
	MOV	R4,#11
	CALL	MDISP		; 'ATTR. BIT 7'
	CALL	MTATT		; ATTRIBUT AUSGEBEN
	CALL	DOWN2		; 2 ZEILEN WEITER
	MOV	R2,#LOW(MZEI)
	MOV	R3,#2		; SPALTE-1
	MOV	R4,#6
	CALL	MDSP		; 'ZEILEN'
	CALL	MTROW		; ZEILENZAHL AUSGEBEN
	MOV	R2,#LOW(MKOMM)
	MOV	R3,#38		; SPALTE-1
	MOV	R4,#13
	CALL	MDSP		; 'KOMMUNIKATION'
	CALL	DOWN2		; 2 ZEILEN WEITER
	MOV	R2,#LOW(MZEICH)
	MOV	R3,#2		; SPALTE-1
	MOV	R4,#11
	CALL	MDSP		; 'ZEICHENSATZ'
	CALL	MTNAT		; ZEICHENSATZ AUSGEBEN
	MOV	R2,#LOW(MLAENG)
	MOV	R3,#34		; SPALTE-1
	MOV	R4,#9
	CALL	MDISP		; 'WORTL[NGE'
	CALL	MTWLEN		; WORTL[NGE AUSGEBEN
	CALL	DOWN2		; 2 ZEILEN WEITER
	MOV	R2,#LOW(MSTAT)
	MOV	R3,#2		; SPALTE-1
	MOV	R4,#11
	CALL	MDISP		; 'STATUSZEILE'
	CALL	MTSTAT		; AN ODER AUS AUSGEBEN
	MOV	R2,#LOW(MBAUD)
	MOV	R3,#34		; SPALTE-1
	MOV	R4,#8
	CALL	MDISP		; 'BAUDRATE'
	CALL	MTBAUD		; BAUDRATE AUSGEBEN
	CALL	DOWN2		; 2 ZEILEN WEITER
	MOV	R2,#LOW(MCTL)
	MOV	R3,#2		; SPALTE-1
	MOV	R4,#12
	CALL	MDISP		; 'CONTROL MODE'
	CALL	MTCTL		; AN ODER AUS AUSGEBEN
	MOV	R2,#LOW(MSTOP)
	MOV	R3,#34		; SPALTE-1
	MOV	R4,#8
	CALL	MDISP		; 'STOPBITS'
	CALL	MTSTOP		; 1 ODER 2 BIT AUSGEBEN
	CALL	DOWN2		; 2 ZEILEN WEITER
	MOV	R2,#LOW(MCURS)
	MOV	R3,#10		; SPALTE-1
	MOV	R4,#6
	CALL	MDSP		; 'CURSOR'
	MOV	R2,#LOW(MPAR)
	MOV	R3,#34		; SPALTE-1
	CALL	MDISP6		; 'PARITY'
	CALL	MTPAR		; PARITY-MODUS AUSGEBEN
	CALL	DOWN2		; 2 ZEILEN WEITER
	MOV	R2,#LOW(MGRO)
	MOV	R3,#2		; SPALTE-1
	MOV	R4,#4
	CALL	MDISP		; 'FORM'
	CALL	MTGRO		; STRICH/BLOCK AUSGEBEN
	MOV	R2,#LOW(MHAND)
	MOV	R3,#34		; SPALTE-1
	MOV	R4,#9
	CALL	MDISP		; 'HANDSHAKE'
	CALL	MTHAND		; AN ODER AUS AUSGEBEN
	CALL	DOWN2		; 2 ZEILEN WEITER
	MOV	R2,#LOW(MART)
	MOV	R3,#2		; SPALTE-1
	MOV	R4,#3
	CALL	MDISP		; 'ART'
	CALL	MTART		; BLINK/RUHEND AUSGEBEN
	CLR	F1		; FORMAT NOCH UNVER[NDERT

; ZWEITER TEIL DER SETUP-ANSTEUERUNG:
; BEWEGEN DES CURSORS UND [NDERN DER EINSTELLUNGEN.

SETP01:	MOV	A,HOME
	MOV	CURS,A		; CURSOR IN ECKE OBEN LINKS
	CALL	DOWN2
	CALL	DOWN2
	CALL	DOWN2
	MOV	A,CURS
	ADD	A,@R1
	MOV	CURS,A		; CURSOR 7 ZEILEN NACH UNTEN

SETP02:	CALL	FREV18		; REVERS AN
STP021:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP022		; KEIN ^E ?
	CALL	FNOR18		; FELD 2 NORMAL
	MOV	R2,#6
STP02L:	CALL	DOWN2
	DJNZ	R2,STP02L	; 12 ZEILEN RUNTER F]R FELD 15
	JMP	SETP15		; FELD 15: HANDSHAKE MODE
STP022:	JNZ	STP023		; ^X : EIN FELD WEITER
	MOV	R1,#REG5
	MOV	A,@R1		; REG5 ENTH[LT BILDBREITE
	ADD	A,#40H		; OBERSTE 2 BITS INKREMENTIEREN
	MOV	@R1,A		; NEUES REG5
	CALL	MTCOL		; ANZEIGEN
	CALL	FREV18		; WIEDER REVERS
	CLR	F1
	CPL	F1		; F1 SETZEN : FORMAT VER[NDERT
	JMP	STP021		; WEITER IN FELD 2
STP023:	CALL	FNOR18		; FELD 2 NORMAL
	CALL	DOWN2		; POSITION FELD 3

SETP03:	CALL	FREV18		; REVERS AN
STP031:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP032		; KEIN ^E ?
	CALL	FNOR18		; FELD 3 NORMAL
	CALL	UP2		; ZUR]CK
	JMP	SETP02
STP032:	JNZ	STP033		; ^X : EIN FELD WEITER
	MOV	R1,#REG5
	MOV	A,@R1		; REG5 ENTH[LT BILDH\HE
	ADD	A,#10H		; BILDH\HE INKREMENTIEREN
	ANL	A,#30H		; NUR NEUE BILDH\HE
	MOV	R2,A		; NACH R2
	MOV	A,@R1		; ALTES REG5
	ANL	A,#0CFH		; ALLES AUSSER ZEILEN
	ORL	A,R2		; NEUE ZEILENZAHL EINSETZEN
	MOV	@R1,A		; NEUES REG5
	CALL	MTROW		; ANZEIGEN
	CALL	FREV18		; WIEDER REVERS
	CLR	F1
	CPL	F1		; F1 SETZEN : FORMAT VER[NDERT
	JMP	STP031		; WEITER IN FELD 3
STP033:	CALL	FNOR18		; FELD 3 NORMAL
	CALL	DOWN2		; POSITION FELD 4

SETP04:	CALL	FREV18		; REVERS AN
STP041:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP042		; KEIN ^E ?
	CALL	FNOR18		; FELD 4 NORMAL
	CALL	UP2		; SONST ZUR]CK
	JMP	SETP03
STP042:	JNZ	STP043		; ^X : EIN FELD WEITER
	MOV	R1,#REG5
	MOV	A,@R1		; REG5 ENTH[LT ZEICHENSATZ
	ADD	A,#2		; ZEICHENSATZ INKREMENTIEREN
	ANL	A,#0EH		; MASKIEREN
	MOV	R2,A		; NACH R2
	MOV	A,@R1		; ALTES REG5
	ANL	A,#0F1H		; ALLES AUSSER ZEICHENSATZ
	ORL	A,R2		; NEUEN ZEICHENSATZ EINSETZEN
	MOV	@R1,A		; NEUES REG5
	CALL	MTNAT		; ANZEIGEN
	CALL	FREV18		; WIEDER REVERS
	JMP	STP041		; WEITER IN FELD 4
STP043:	CALL	FNOR18		; FELD 4 NORMAL
	CALL	DOWN2		; POSITION FELD 5

SETP05:	CALL	FREV18		; REVERS AN
STP051:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP052		; KEIN ^E ?
	CALL	FNOR18		; FELD 5 NORMAL
	CALL	UP2		; SONST ZUR]CK
	JMP	SETP04
STP052:	JNZ	STP053		; ^X : EIN FELD WEITER
	MOV	R1,#REG4
	MOV	A,@R1		; REG4 ENTH[LT STATUS AN/AUS
	XRL	A,#80H		; BIT INVERTIEREN
	MOV	@R1,A		; NEUES REG4
	CALL	MTSTAT		; ANZEIGEN
	CALL	FREV18		; WIEDER REVERS
	JMP	STP051		; WEITER IN FELD 5
STP053:	CALL	FNOR18		; FELD 5 NORMAL
	CALL	DOWN2		; POSITION FELD 6

SETP06:	CALL	FREV18		; REVERS AN
STP061:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP062		; KEIN ^E ?
	CALL	FNOR18		; FELD 6 NORMAL
	CALL	UP2		; SONST ZUR]CK
	JMP	SETP05
STP062:	JZ	STP069
	JMP	STP063		; ^X: EIN FELD WEITER
STP069:	MOV	A,R7		; BOOLEAN FLAG: CTL MODE
	XRL	A,#2		; BIT INVERTIEREN
	MOV	R7,A		; NEUES BOOLEAN FLAG
	CALL	MTCTL		; ANZEIGEN
	CALL	FREV18		; WIEDER REVERS
	JMP	STP061		; WEITER IN FELD 6
STP063:	CALL	FNOR18		; FELD 6 NORMAL
	CALL	DOWN2
	CALL	DOWN2		; POSITION FELD 7

SETP07:	CALL	FREV18		; REVERS AN
STP071:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP072		; KEIN ^E ?
	CALL	FNOR18		; FELD 7 NORMAL
	CALL	UP2		; SONST ZUR]CK
	CALL	UP2
	JMP	SETP06
STP072:	JNZ	STP073		; ^X : EIN FELD WEITER
	MOV	R1,#REG4
	MOV	A,@R1		; REG4 ENTH[LT CURSOR-SIZE
	XRL	A,#4		; BIT INVERTIEREN
	MOV	@R1,A		; NEUES REG4
	CALL	MTGRO		; ANZEIGEN
	CALL	FREV18		; WIEDER REVERS
	JMP	STP071		; WEITER IN FELD 7
STP073:	CALL	FNOR18		; FELD 7 NORMAL
	CALL	DOWN2		; POSITION FELD 8

SETP08:	CALL	FREV18		; REVERS AN
STP081:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP082		; KEIN ^E ?
	CALL	FNOR18		; FELD 8 NORMAL
	CALL	UP2		; SONST ZUR]CK
	JMP	SETP07
STP082:	JNZ	STP085		; ^X : EIN FELD WEITER
	MOV	A,R7		; BOOLEAN FLAG
	JB3	STP083		; CURSOR OFF ? --> ON
	MOV	R1,#REG4
	MOV	A,@R1		; REG4 ENTH[LT CURSOR-ART
	XRL	A,#2		; BIT INVERTIEREN
	MOV	@R1,A		; NEUES REG4
	JB1	STP084
STP083:	MOV	A,R7
	XRL	A,#8		; CURSOR ON <--> OFF
	MOV	R7,A
STP084:	CALL	MTART		; ANZEIGEN
	CALL	FREV18		; WIEDER REVERS
	JMP	STP081		; WEITER IN FELD 8
STP085:	CALL	FNOR18		; FELD 8 NORMAL
	MOV	A,HOME
	MOV	CURS,A		; CURSOR HOME
	CALL	DOWN2
	CALL	DOWN2
	MOV	A,CURS
	ADD	A,@R1
	MOV	CURS,A		; 5 ZEILEN TIEFER: FELD 9

SETP09:	CALL	FREV50		; REVERS AN
STP091:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP092		; KEIN ^E ?
	CALL	FNOR50		; FELD 9 NORMAL
	MOV	R2,#8
STP09L:	CALL	DOWN2
	DJNZ	R2,STP09L	; 16 ZEILEN RUNTER: FELD 8
	JMP	SETP08
STP092:	JNZ	STP093		; ^X : EIN FELD WEITER
	MOV	R1,#REG4
	MOV	A,@R1		; REG4 ENTH[LT REVVID
	XRL	A,#8		; BIT INVERTIEREN
	MOV	@R1,A		; NEUES REG4
	CALL	MTREV		; ANZEIGEN
	CALL	FREV50		; WIEDER REVERS
	JMP	STP091		; WEITER IN FELD 9
STP093:	CALL	FNOR50		; FELD 9 NORMAL
	CALL	DOWN2		; POSITION FELD 10

SETP10:	CALL	FREV50		; REVERS AN
STP101:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP102		; KEIN ^E ?
	CALL	FNOR50		; FELD 10 NORMAL
	CALL	UP2		; 2 ZEILEN RAUF
	JMP	SETP09
STP102:	JNZ	STP103		; ^X : EIN FELD WEITER
	CALL	MCHATT		; MASKE [NDERN UND ANZEIGEN
	CALL	FREV50		; WIEDER REVERS
	JMP	STP101		; WEITER IN FELD 10
STP103:	CALL	FNOR50		; FELD 10 NORMAL
	CALL	DOWN2
	CALL	DOWN2		; POSITION FELD 11

SETP11:	CALL	FREV50		; REVERS AN
STP111:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP112		; KEIN ^E ?
	CALL	FNOR50		; FELD 11 NORMAL
	CALL	UP2
	CALL	UP2		; 4 ZEILEN RAUF
	JMP	SETP10
STP112:	JNZ	STP113		; ^X : EIN FELD WEITER
	MOV	R1,#REG5
	MOV	A,@R1		; REG5 ENTH[LT WORTL[NGE
	XRL	A,#1		; BIT INVERTIEREN
	MOV	@R1,A
	CALL	MTWLEN		; NEUE WORTL[NGE ANZEIGEN
	CALL	FREV50		; WIEDER REVERS
	JMP	STP111		; WEITER IN FELD 11
STP113:	CALL	FNOR50		; FELD 11 NORMAL
	CALL	DOWN2		; POSITION FELD 12

SETP12:	CALL	FREV50		; REVERS AN
STP121:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP122		; KEIN ^E ?
	CALL	FNOR50		; FELD 12 NORMAL
	CALL	UP2		; 2 ZEILEN RAUF
	JMP	SETP11
STP122:	JNZ	STP125		; ^X : EIN FELD WEITER
	MOV	R1,#REG6
	MOV	A,@R1		; REG6 ENTH[LT BAUDRATE
	ADD	A,#10H		; INKREMENTIEREN
	MOV	@R1,A		; SPEICHERN FALLS OK
	ADD	A,#30H		; ZWEITE 19200 ERREICHT ?
	JNC	STP123		; NEIN: WEITER
	MOV	A,@R1
	ANL	A,#0FH		; JA: BAUDRATE AUF 110 SETZEN
	MOV	@R1,A
STP123:	CALL	MTBAUD		; NEUE BAUDRATE ANZEIGEN
	CALL	FREV50		; WIEDER REVERS
	JMP	STP121		; WEITER IN FELD 12
STP125:	CALL	FNOR50		; FELD 12 NORMAL
	CALL	DOWN2		; POSITION FELD 13

SETP13:	CALL	FREV50		; REVERS AN
STP131:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP132		; KEIN ^E ?
	CALL	FNOR50		; FELD 13 NORMAL
	CALL	UP2		; 2 ZEILEN RAUF
	JMP	SETP12		; WIEDER FELD 12
STP132:	JNZ	STP133		; ^X : EIN FELD WEITER
	MOV	R1,#REG6
	MOV	A,@R1		; REG6 ENTH[LT STOPBITS
	XRL	A,#1		; BIT INVERTIEREN
	MOV	@R1,A		; NEUES REG6
	CALL	MTSTOP		; NEUE STOPBITZAHL ANZEIGEN
	CALL	FREV50		; WIEDER REVERS
	JMP	STP131		; WEITER IN FELD 13
STP133:	CALL	FNOR50		; FELD 13 NORMAL
	CALL	DOWN2		; POSITION FELD 14

SETP14:	CALL	FREV50		; REVERS AN
STP141:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JF0	STP149
	JMP	STP142		; KEIN ^E ?
STP149:	CALL	FNOR50		; FELD 14 NORMAL
	CALL	UP2		; 2 ZEILEN RAUF
	JMP	SETP13
STP142:	JNZ	STP144		; ^X : EIN FELD WEITER
	MOV	R1,#REG6
	MOV	A,@R1		; REG6 ENTH[LT PARITY
	RR	A		; PARITY-BITS RECHTS
	INC	A		; ERH\HEN
	ANL	A,#7		; 3 BITS
	JZ	STP143		; BEI 0 NICHT WEITER ERH\HEN
	JB0	STP143		; UNGERADE ?
	INC	A		; SONST -> UNGERADE
STP143:	RL	A
	MOV	R2,A		; NEUER WERT NACH R2
	MOV	A,@R1		; ALTES REG6
	ANL	A,#0F1H		; ALLES AUSSER PARITY
	ORL	A,R2		; NEUE PARITY
	MOV	@R1,A		; NEUES REG6
	CALL	MTPAR		; NEUE PARITY ANZEIGEN
	CALL	FREV50		; WIEDER REVERS
	JMP	STP141		; WEITER IN FELD 14
STP144:	CALL	FNOR50		; FELD 14 NORMAL
	CALL	DOWN2		; POSITION FELD 15

SETP15:	CALL	FREV50		; REVERS AN
STP151:	CALL	INPUT		; ZEICHEN ANNEHMEN
	JNF0	STP152		; KEIN ^E ?
	CALL	FNOR50		; FELD 15 NORMAL
	CALL	UP2		; 2 ZEILEN RAUF
	JMP	SETP14
STP152:	JNZ	STP153		; ^X : EIN FELD WEITER
	MOV	R1,#REG4
	MOV	A,@R1		; REG4 ENTH[LT HANDSHAKE
	XRL	A,#20H		; BIT INVERTIEREN
	MOV	@R1,A		; NEUES REG4
	CALL	MTHAND		; NEU ANZEIGEN
	CALL	FREV50		; WIEDER REVERS
	JMP	STP151		; WEITER IN FELD 15
STP153:	CALL	FNOR50		; FELD 15 NORMAL
	JMP	SETP01		; => POSITION 2 (SPALTEN)

; R]CKKEHR AUS SETUP-MEN]. DIE POINTER F]R HOME UND CURSOR
; WERDEN WIEDER AUF DIE ALTEN WERTE GESETZT, DIE Z[HLER F]R
; ZEILE UND SPALTE EBENSO, DES WEITEREN WIRD BEI VER[NDERTEM
; TERMINAL-FORMAT EIN FORMFEED DURCHGEF]HRT, ANSONSTEN NUR 
; EINE NORMALE INITIALISIERUNG (KRITERIUM : F1).

SETPX:	MOV	A,#1FH
	MOV	HACC,A
	MOV	A,#0FFH		; ACCU AUF SPEICHERENDE (1FFF)
	MOVL	R1,A
	MOVX	A,@R1		; CURSOR HOLEN
	MOV	CURS,A
	DECL	R1
	MOVX	A,@R1		; HOME HOLEN
	MOV	HOME,A
	DECL	R1
	MOVX	A,@R1		; R5 (ZEILE) HOLEN
	MOV	R5,A
	DECL	R1
	MOVX	A,@R1		; R6 (SPALTE) HOLEN
	MOV	R6,A
	CLR	A
	MOV	HACC,A
	MOV	BEGD,A		; ANFANG WIEDER AUF 0
	SEL	MB0
	CALL	INIT		; NEU INITIALISIEREN
	SEL	MB2
	CALL	LDSEND
	MOV	ENDD,A		; ENDE WIEDER RICHTIG
	CALL	STSET		; STATUSZEILE AKTUALISIEREN
	JNF1	SUPRET		; FORMAT VER[NDERT ?
	JMP	FFD		; SEITE L\SCHEN, C=R=1, HLOOP
SUPRET:	SEL	MB0
	JMP	HLOOP		; ZUR]CK ZUR HAUPTSCHLEIFE

; ES FOLGEN DIE TEXTE F]R DAS SETUP-MEN]

	ORG	0E7DH		; SO ENDE DER TEXTE BEI 0FFF

TITEL:	DB	0DFH,'REH Universal Terminal - Version 2.2'
MTERM:	DB	0DFH,'TERMINAL'
MCURS:	DB	0DFH,'CURSOR'
MVID:	DB	0DFH,'VIDEO'
MKOMM:	DB	0DFH,'KOMMUNIKATION'

MEMU:	DB	0FFH,'Emulation'
MSPA:	DB	0FFH,'Spalten'
MZEI:	DB	0FFH,'Zeilen'
MZEICH:	DB	0FFH,'Zeichensatz'

MDSP:	MOV	A,CURS		; ZEILENANFANG
	ADD	A,R3		; AUF ENTSPR. SPALTE
	MOVL	R1,A		; R1 ALS ZEIGER
	MOV	A,R2
	MOVP	A,@A		; ERSTES BYTE: ATTRIBUTE
	MOV	HACC,A
MDSP1:	INC	R2		; ZEIGER AUF N[CHSTES ZEICHEN
	MOV	A,R2
	MOVP	A,@A		; ZEICHEN HOLEN
	MOVX	@R1,A		; ABSPEICHERN
	INCL	R1
	DJNZ	R4,MDSP1	; BIS TEXTENDE
	RET

MDISP5:	MOV	R4,#5		; 5 ZEICHEN
	JMP	MDISP		; TEXT AUSGEBEN
MDISP6:	MOV	R4,#6		; 6 ZEICHEN
MDISP:	MOV	A,CURS		; ZEILENANFANG
	ADD	A,R3		; AUF ENTSPR. SPALTE
	MOVL	R1,A		; R1 ALS ZEIGER
	MOV	A,#-1		; ALLE ATTRIBUTE AUS
	MOV	HACC,A
MDISP1:	MOV	A,R2		; ZEIGER AUF TEXT
	MOVP	A,@A		; ZEICHEN HOLEN
	MOVX	@R1,A		; ABSPEICHERN
	INC	R2		; ZEIGER AUF N[CHSTES ZEICHEN
	INCL	R1
	DJNZ	R4,MDISP1	; BIS TEXTENDE
	RET

INFO:	DB	'Auswahl mit ^E und ^X, '
    IF MHZ12
	DB	1BH,'ndern mit Leertaste'
    ENDIF
    IF MHZ18
	DB	11H,'ndern mit Leertaste'
    ENDIF
MSTAT:	DB	'Statuszeile'
MCTL:	DB	'Control Mode'
MGRO:	DB	'Form'
MART:	DB	'Art'
MREV:	DB	'Hintergrund'
MATTR:	DB	'Attr. Bit 7'
    IF MHZ12
MLAENG:	DB	'Wortl',1BH,'nge'
    ENDIF
    IF MHZ18
MLAENG:	DB	'Wortl',11H,'nge'
    ENDIF
MBAUD:	DB	'Baudrate'
MSTOP:	DB	'Stopbits'
MPAR:	DB	'Parity'
MHAND:	DB	'Handshake'
STRICH:	DB	'STRICH'
BLOCK:	DB	' BLOCK'
BLINK:	DB	' BLINK'
RUHEND:	DB	'RUHEND'
REVERS:	DB	'REVERS'
UNDERL:	DB	'UNDERL'
AN:	DB	'    AN'
AUS:	DB	'   AUS'
HELL:	DB	'  HELL'
DUNKEL:	DB	'DUNKEL'
BIT8:	DB	'8 BIT'
BIT7:	DB	'7 BIT'
BIT2:	DB	'2 BIT'
BIT1:	DB	'1 BIT'
EVEN:	DB	' EVEN'
ODD:	DB	'  ODD'
MARK:	DB	' MARK'
SPACE:	DB	'SPACE'
HARD:	DB	' DTR'
XOFF:	DB	'XOFF'

	END
