	TITLE	'TERMINAL-BASISPROGRAMM F]R TMP NS405/455'
	SBTTL	"C'T TEXT-TERMINAL SOFTWARE V2.2"
	WIDTH	80
	NOLIST
	INCLUD	EQUATES.ASM
	LIST
	ORG	0		; BANK 0

; T. REH 26.07.89

RESET:	JMP	START		; KALTSTARTEINSPRUNG
	DS	1
EXTRAP:	JMP	EXTINT		; EXTERNER INTERRUPT (TAST.)
	DS	2
INTRAP:	JMP	INTINT		; INTERNER INTERRUPT (V.24)
	DS	1

; UNTERPROGRAMME AUS ANDEREN MODULEN

SETUP	EQU	800H		; SETUP-MEN] EINSPRUNG
CTLCOD	EQU	1000H		; CTL-CODE-BEARBEITUNG
CRIGHT	EQU	1002H		; CURSOR RIGHT
CURUP	EQU	1004H		; CURSOR UP
CDOWN	EQU	1006H		; CURSOR DOWN
CTLCD2	EQU	1008H		; ZUS[TZLICHE CTL-CODES
STSET	EQU	100AH		; STATUSZEILE AUFFRISCHEN
FFD	EQU	100EH		; BILDSCHIRM L\SCHEN
LDSEND	EQU	1012H		; BILD-ENDADRESSE NACH A
STMODE	EQU	101AH		; STATUS ONL/LOC/SUP ANZEIGEN

; EINSPRUNGVEKTOR F]R ANDERE MODULE

	JMP	INIT		; KPL. INIT TERMINAL
	JMP	CI		; KONSOLEN-INPUT IN R3
	JMP	CO		; KONSOLEN-OUTPUT IN R3
	JMP	HLOOP		; HAUPTSCHLEIFE ZEICHENDARST.

; INITIALISIERUNG DER TERMINAL-PARAMETER,
; DER VIDEOEIGENSCHAFTEN, BAUDRATE USW.

INIT:	DIS	II
	DIS	XI
	MOV	R1,#REG5
	MOV	A,@R1		; REG5 LESEN
	INC	R1
	RRC	A		; WRDLEN INS CARRY SCHIEBEN
	MOV	A,@R1		; REG6 LESEN
	RLC	A		; WRDLEN EINSCHIEBEN
	ANL	A,#1FH		; NUR UNTERE 5 BIT G]LTIG
	MOV	UCR,A		; UART CONTROL SETZEN
	MOV	A,#1
	MOV	UMX,A		; UMX = 1 (GLEICHE BAUDRATEN)

	DEC	R1
	MOV	A,@R1		; REG5 LESEN
	SWAP	A
	MOV	R2,A
	RR	A
	RR	A
	ANL	A,#3		; NUR ZEILENL[NGE (ROWLEN)
	ADD	A,#COLTAB
	MOVP	A,@A
	MOV	R0,#ROWLEN
	MOV	@R0,A		; SPALTENZAHL ABSPEICHERN
	MOV	R3,A		; NACH R3 ZUR ADRESSBERECHNUNG
	INC	R0
	MOV	A,R2
	ANL	A,#3		; NUR ZEILENZAHL (ROWNUM)
	ADD	A,#ROWTAB
	MOVP	A,@A
	MOV	@R0,A		; ZEILENZAHL ABSPEICHERN
	MOV	R2,A		; UND NACH R2
	CLR	A
	MOV	HACC,A		; ACCU AUF 0 (16 BIT)
	MOV	BEGD,A		; DISPLAY-RAM ANFANG
INIT1:	ADD	A,R3		; ZEILENL[NGE ADDIEREN
	DJNZ	R2,INIT1	; * ZEILENZAHL
	MOV	ENDD,A
	MOV	SROW,A		; SPEICHERENDE F]R DISPLAY
	INC	R0
	MOV	@R0,A		; ENDLO ABSPEICHERN
	INC	R0
	MOV	A,HACC
	MOV	@R0,A		; ENDHI ABSPEICHERN

	MOV	A,@R1		; REG5
	RR	A
	ANL	A,#7		; ZEICHENSATZ
	ADD	A,#NATS
	MOVP	A,@A
	MOV	R0,#NATTAB
	MOV	@R0,A		; TABELLENADRESSE SPEICHERN

	MOV	A,@R1		; REG5
	SWAP	A
	ANL	A,#0CH		; NUR COLNUM * 4
	MOV	R4,A		; F]R SP[TER
	RR	A
	RR	A		; COLNUM
	MOV	R3,A		; F]R SP[TER
	ADD	A,#SCRTAB
	MOVP	A,@A		; SCR-WERT HOLEN
	MOV	SCR,A		; SCR ENDG]LTIG SETZEN 
	MOV	A,R4		; 4 * COLNUM
	ADD	A,R3		; 5 * COLNUM
	ADD	A,#COL0
	MOV	R2,A		; TABELLENADRESSE
	CLR	A
	MOV	TCP,A		; TCP R]CKSETZEN
	MOV	R3,#4		; ZUN. 4 WERTE ABH. VON COLNUM
IVLP1:	MOV	A,R2
	MOVP	A,@A		; WERT AUS TABELLE
	MOV	@TCP,A		; --> TCP
	INC	R2		; POINTER ERH\HEN
	DJNZ	R3,IVLP1
	MOV	A,@R1		; REG5
	SWAP	A
	ANL	A,#3		; NUR ROWNUM
	MOV	R3,A		; ROWNUM
	RL	A
	MOV	R4,A		; 2 * ROWNUM
	RL	A		; 4 * ROWNUM
	ADD	A,R4		; 6 * ROWNUM
	ADD	A,R3		; 7 * ROWNUM
	ADD	A,#ROW0
	MOV	R4,A		; TABELLENADRESSE
	MOV	R3,#6		; ZUN. 6 WERTE ABH. VON ROWNUM
IVLP2:	MOV	A,R4
	MOVP	A,@A
	MOV	@TCP,A		; ROW-ABH. WERTE
	INC	R4
	DJNZ	R3,IVLP2
	MOV	A,R2
	MOVP	A,@A		; COLNUM-ABH[NGIGER WERT
	MOV	@TCP,A
	MOV	A,R4
	MOVP	A,@A		; ROWNUM-ABH[NGIGER WERT
	MOV	@TCP,A
    IF MHZ12
	MOV	A,#89H		; UNDERLINE SIZE (5X7)
    ENDIF
    IF MHZ18
	MOV	A,#0ABH		; UNDERLINE SIZE (7X9)
    ENDIF
	MOV	@TCP,A
	MOV	A,R7		; BOOLEAN FLAG
	JB3	NOCURS		; CURSOR OFF ?
	DEC	R1
	MOV	A,@R1		; REG4
	JB2	CBLOCK
    IF MHZ12
	MOV	A,#79H		; UNDERLINE CURSOR (5X7)
    ENDIF
    IF MHZ18
	MOV	A,#9BH		; UNDERLINE CURSOR (7X9)
    ENDIF
	JMP	CSET
CBLOCK:	MOV	A,#0FH		; BLOCK CURSOR
	JMP	CSET
NOCURS:	MOV	A,#0F0H		; KEIN CURSOR
CSET:	MOV	@TCP,A		; CURSOR SETZEN
	MOV	A,@R1		; REG4
	ANL	A,#0AH		; NUR REVVID UND CBLINK
	ORL	A,#35H
	MOV	VCR,A		; VIDEO CONTROL SETZEN
	MOV	R1,#REG6
	MOV	A,@R1		; REG6 LESEN
	SWAP	A
	ANL	A,#0FH
	MOV	R3,A		; BAUDRATE NACH R3 F]R PRESCALER
	ADD	A,#LOW(BODTAB)
	MOVP3	A,@A
	MOV	BAUD,A		; EINTRAG HOLEN UND NACH BAUD
	MOV	A,R3
	ADD	A,#LOW(PSRTAB)
	MOVP3	A,@A
	MOV	PSR,A		; EINTRAG F]R PSR
	EN	II
	EN	XI
RETP0:	RET

; VIDEO-FORMAT-TABELLEN ZUR INITIALISIERUNG

    IF Z17300
COLTAB:	DB	72,80,88,92		; SPALTENZAHLEN (17300)
    ELSE
     IF Z20820
COLTAB:	DB	72,80,72,80		; SPALTENZAHLEN (20820)
     ELSE
COLTAB:	DB	72,80,88,96		; SPALTENZAHLEN NORMAL
     ENDIF
    ENDIF
    IF Z17300 OR Z17550 OR Z20820
ROWTAB:	DB	22,24,26,27		; ZEILEN (17300/17550)
    ELSE
ROWTAB:	DB	22,24,26,28		; ZEILENZAHLEN (SONST)
    ENDIF
    IF Z15600
SCRTAB:	DB	16H,14H,14H,12H		; SCR-WERTE (DOT WIDTH)
    ENDIF
    IF Z16650
SCRTAB:	DB	16H,14H,12H,12H		; SCR-WERTE (DOT WIDTH)
    ENDIF
    IF Z17300
SCRTAB:	DB	1BH,1BH,19H,19H		; SCR-WERTE (DOT WIDTH)
    ENDIF
    IF Z17550
SCRTAB:	DB	1BH,1BH,19H,17H		; SCR-WERTE (DOT WIDTH)
    ENDIF
    IF Z17850
SCRTAB:	DB	1BH,19H,19H,17H		; SCR-WERTE (DOT WIDTH)
    ENDIF
    IF Z18400
SCRTAB:	DB	1BH,19H,17H,17H		; SCR-WERTE (DOT WIDTH)
    ENDIF
    IF Z20820
SCRTAB:	DB	19H,17H,19H,17H		; SCR-WERTE (DOT WIDTH)
    ENDIF

; HORIZONTALE WERTE F]R TIMING CHAIN

    IF Z15600
COL0:	DB	95,71,78,87,38H		; 72 SPALTEN
	DB	109,79,88,98,30H	; 80 SPALTEN
	DB	109,87,92,102,30H	; 88 SPALTEN
	DB	127,95,103,115,30H	; 96 SPALTEN
    ENDIF
    IF Z16650
COL0:	DB	89,71,75,84,38H		; 72 SPALTEN
	DB	102,79,84,94,30H	; 80 SPALTEN
	DB	119,87,95,107,30H	; 88 SPALTEN
	DB	119,95,99,111,30H	; 96 SPALTEN
    ENDIF
    IF Z17300
COL0:	DB	103,71,80,91,1EH	; 72 SPALTEN
	DB	103,79,84,95,1EH	; 80 SPALTEN
	DB	115,87,93,105,3CH	; 88 SPALTEN
	DB	115,91,95,107,3CH	; 92 SPALTEN
    ENDIF
    IF Z17550
COL0:	DB	102,71,80,91,1EH	; 72 SPALTEN
	DB	102,79,84,95,1EH	; 80 SPALTEN
	DB	113,87,92,104,3CH	; 88 SPALTEN
	DB	127,95,102,115,38H	; 96 SPALTEN
    ENDIF
    IF Z17850
COL0:	DB	100,71,79,90,1EH	; 72 SPALTEN
	DB	111,79,87,99,3CH	; 80 SPALTEN
	DB	111,87,91,103,3CH	; 88 SPALTEN
	DB	125,95,101,114,38H	; 96 SPALTEN
    ENDIF
    IF Z18400
COL0:	DB	97,71,77,88,1EH		; 72 SPALTEN
	DB	108,79,85,97,3CH	; 80 SPALTEN
	DB	121,87,95,108,38H	; 88 SPALTEN
	DB	121,95,99,112,38H	; 96 SPALTEN
    ENDIF
    IF Z20820
COL0:	DB	95,71,75,87,3CH		; 72 SPALTEN
	DB	107,79,84,97,38H	; 80 SPALTEN
	DB	95,71,75,87,3CH		; 72 SPALTEN
	DB	107,79,84,97,38H	; 80 SPALTEN
    ENDIF

; VERTIKALE WERTE F]R TIMING CHAIN

    IF Z15600
ROW0:	DB	0BBH,25,22,90H,21,0C4H,48H	; 22 ZEILEN
	DB	0A3H,27,24,0A2H,23,0C4H,47H	; 24 ZEILEN
	DB	091H,30,26,92H,25,0C4H,37H	; 26 ZEILEN
	DB	091H,30,28,25H,27,0C4H,37H	; 28 ZEILEN
    ENDIF
    IF Z16650
ROW0:	DB	0C7H,24,22,8BH,21,0C4H,49H	; 22 ZEILEN
	DB	0B8H,26,24,8BH,23,0C4H,48H	; 24 ZEILEN
	DB	0A2H,29,26,91H,25,0C4H,47H	; 26 ZEILEN
	DB	0A2H,29,27,47H,31,0C4H,47H	; 28 ZEILEN-S
    ENDIF
    IF Z17300
ROW0:	DB	0D9H,23,22,36H,21,0C4H,59H	; 22 ZEILEN
	DB	0C7H,25,24,25H,23,0C4H,49H	; 24 ZEILEN
	DB	0B9H,27,26,25H,25,0C4H,48H	; 26 ZEILEN
	DB	0B9H,27,26,25H,31,0C4H,48H	; 27 ZEILEN-S
    ENDIF
    IF Z17550
ROW0:	DB	0D0H,24,22,69H,21,0C4H,59H	; 22 ZEILEN
	DB	0CCH,26,24,47H,23,0C4H,49H	; 24 ZEILEN
	DB	0B2H,28,26,58H,25,0C4H,48H	; 26 ZEILEN
	DB	0B2H,28,26,58H,31,0C4H,48H	; 27 ZEILEN-S
    ENDIF
    IF Z17850
ROW0:	DB	0D6H,24,22,9CH,21,0C4H,59H	; 22 ZEILEN
	DB	0C5H,26,24,7AH,23,0C4H,49H	; 24 ZEILEN
	DB	0B8H,28,26,8BH,25,0C4H,48H	; 26 ZEILEN
	DB	0B8H,28,27,25H,31,0C4H,48H	; 28 ZEILEN-S
    ENDIF
    IF Z18400
ROW0:	DB	0E7H,23,22,36H,21,0C4H,5AH	; 22 ZEILEN
	DB	0C3H,27,24,0C2H,23,0C4H,49H	; 24 ZEILEN
	DB	0B7H,29,26,0B2H,25,0C4H,48H	; 26 ZEILEN
	DB	0B7H,29,28,14H,27,0C4H,48H	; 28 ZEILEN
    ENDIF
    IF Z20820
ROW0:	DB	0DAH,23,22,47H,21,0C4H,59H	; 22 ZEILEN
	DB	0C8H,25,24,25H,23,0C4H,49H	; 24 ZEILEN
	DB	0BAH,27,26,36H,25,0C4H,48H	; 26 ZEILEN
	DB	0BAH,27,26,36H,31,0C4H,48H	; 27 ZEILEN-S
    ENDIF

; OPTIONSTABELLEN-ADRESSEN

NATS:	DB	NATUSA,NATFRA,NATGER	; NATIONALE ZEICHENS[TZE
	DB	NATGB,NATDEN,NATSWE
	DB	NATITA,NATSPA

; REGX LIEST SWITCH-REGISTER AUS. HIGH-ADRESSE IN A BEIM AUFRUF.

REGX:	MOV	HACC,A		; POINTER AUF REGISTER
	MOVL	R1,A
	MOVX	A,@R1		; INHALT NACH A LESEN
	RET

; BEARBEITUNG INTERNER INTERRUPTS. EINGEHENDE INTERRUPTS WERDEN
; AUF IHRE URSACHE GEPR]FT. BEI UART-EMPF[NGER-INTERRUPT WIRD
; DAS ANGEKOMMENE ZEICHEN IM RINGPUFFER GESPEICHERT. IST DER
; RINGPUFFER BIS AUF DREI ZEICHEN GEF]LLT, SO WIRD DTR R]CK-
; GESETZT (HARDWARE-HANDSHAKE V.24) BZW. XOFF GESENDET.
; HANDSHAKE-SCHWELLE BELIEBIG VER[NDERBAR (2..14 ZEICHEN).
; BEI REAL-TIME-INTERRUPT WIRD UHR NACHGESTELLT. ANZEIGE DER
; UHR ERFOLGT IN DISPL.
; LAUFZEITEN: RT 76c=95us, V24 66c=83us, RT+V24 122c=153us.
; (NUR BEI HARDWARE-HANDSHAKE DURCH DTR, SONST L[NGER.)

INTINT:	SEL	RB1		; REGISTER BANK 1 F]R INTERRUPTS
	MOV	R7,A		; ACCU RETTEN
	MOV	A,HACC
	MOV	R6,A
	MOV	A,INTR		; INTERRUPTQUELLE LESEN
	CPL	A
	JB7	INTNRT
	MOV	R0,#SECOND
	MOV	R3,#60H		; GRENZE F]R MIN UND SEC
	CALL	RTINC		; SEKUNDEN INC
	JC	INT1
	DEC	R0
	CALL	RTINC		; MINUTEN INC
	JC	INT1
	DEC	R0
	MOV	R3,#24H		; NEUE GRENZE
	CALL	RTINC		; STUNDEN INC
INT1:	MOV	A,INTR
	CPL	A		; SONST:
INTNRT:	JB4	INTRET		; ALLES AUSSER V.24 IGNORIEREN
	MOV	A,STAT
	ANL	A,#0EH		; ZEICHEN FEHLERFREI EMPFANGEN ?
	JNZ	INTIGN		; NEIN --> IGNORIEREN
	MOV	R0,#WRPTR
	MOV	A,@R0
	MOV	R1,A		; WRITE-POINTER IN R1
	IN	RCVR
	MOV	@R1,A		; ZEICHEN NACH RING SPEICHERN
	INC	R1
	MOV	A,R1
	ANL	A,#RNGEND	; POINTER ERH\HEN UND MASKIEREN
	MOV	@R0,A		; POINTER ABSPEICHERN
	CPL	A
	INC	A
	MOV	R2,A		; UND NEGIERT NACH R2
	INC	R0
	MOV	A,@R0		; READ-POINTER IN A
	ADD	A,R2		; DIFFERENZ READ-WRITE
	ANL	A,#RNGEND AND 0FH ; AUF PUFFERL[NGE BESCHR[NKEN
	ADD	A,#-4
	JC	INTRET		; WENIGER ALS 4 ZEICHEN PLATZ :
	ORL	PORT,#DTR	; DTR DER V.24 WEGNEHMEN
	MOV	R1,#7
	MOV	A,@R1		; BOOLEAN FLAG
	JB5	INTRET		; WENN SCHON HANDSHAKE: WEITER
	ORL	A,#20H
	MOV	@R1,A		; SONST FLAG SETZEN
	MOV	R1,#REG4
	MOV	A,@R1		; REG4 LESEN
	CPL	A
	JB5	INTRET		; HARDWARE-HANDSHAKE: WEITER
	MOV	R3,#XOFFC
	CALL	CO		; SONST XOFF SENDEN
INTRET:	MOV	A,R6
	MOV	HACC,A
	MOV	A,R7		; ACCU WIEDERHERSTELLEN
	SEL	RB0
	RETR			; ENDE DER INTERRUPT-ROUTINE

INTIGN:	IN	RCVR		; DUMMY-READ LEERT UART-REGISTER
	JMP	INTRET

; F]R UHR: @R0 BCD ERH\HEN. ]BERLAUF WENN WERT IN R3 ERREICHT.

RTINC:	MOV	A,@R0		; ZU BEARBEITENDER BCD-WERT
	ADD	A,#1
	DA	A		; DEZIMAL ERH\HEN, CY:=0
	XRL	A,R3		; GRENZE ERREICHT ?
	JZ	RTINC1		; WENN GRENZE: WIEDER NULL
	XRL	A,R3		; SONST WERT RESTAURIEREN
	CPL	C		; CY:=1 WENN WERT OK
RTINC1:	MOV	@R0,A		; NEUEN WERT SPEICHERN
	RET

; EXTERNER INTERRUPT VERURSACHT EINLESEN DER TASTATUR (8-BIT-
; PARALLEL BZW. IBM-SERIELL) UND ABSPEICHERN DES ZEICHENS IM
; TASTENPUFFER. IN 'STATUS' WERDEN DIE CODES ZUR HOSTSCHNITTST.
; WEITERGEREICHT (NUR BEI ONLINE). BEI BET[TIGEN DER TASTEN
; LOCAL ODER SETUP WIRD DER ENTSPR. MODUS GEW[HLT UND ANGEZEIGT.
; LAUFZEITEN: NORMAL 47c=59us, LOCAL/SETUP max 144c=180us.
; STEHT DER STB-IMPULS L[NGER AN, SO IST LAUFZEIT=STB-DAUER!

SERINT:	JMP	SERIN		; SERIELLE TASTATUR LESEN

EXTINT:	SEL	RB1
	MOV	R7,A		; ACCU RETTEN
	MOV	A,HACC
	MOV	R6,A
	MOV	R1,#REG4
	MOV	A,@R1		; REG4 LESEN WEGEN SERPAR
	JB4	SERINT		; SERIELLE TASTATUR
	IN	PORT		; ZEICHEN VON TASTATUR
	MOV	R3,A		; NACH R3
SERRET:	MOV	A,R3		; ZEICHEN VON TASTATUR
	ADD	A,#-LKEY
	JZ	SETLOC		; IN LOCAL-MODE GEHEN
	ADD	A,#LKEY-SKEY
	JZ	SETSET		; IN SETUP-MODE GEHEN
EXTIN1:	MOV	R1,#TBUFF	; NICHT LKEY/SKEY: NACH TBUFF
	MOV	A,R3
	MOV	@R1,A		; ZEICHEN IN TASTENPUFFER
	MOV	R1,#7
	MOV	A,@R1		; BOOLEAN FLAG
	ORL	A,#40H		; BIT6 (TFLAG) SETZEN
	MOV	@R1,A
EXTRET:	JNXI	$		; WARTEN BIS INTERRUPT INAKTIV
	JMP	INTRET		; REGISTER RESTAURIEREN/RETR

; LOCAL-TASTE WURDE BET[TIGT. LOCAL-FLAG WIRD INVERTIERT.
; WENN SETUP-MODE AKTIV WAR, WIRD SKEY ZUM HOST GESENDET.

SETLOC:	MOV	R1,#7
	MOV	A,@R1		; BOOLEAN FLAG
	JB2	SETLS		; SETUP AKTIV: SKEY SENDEN
	XRL	A,#1		; TOGGLE LOCAL FLAG
	JMP	SETLS2		; STATUS ANZ./ EXTRET

SETLS:	MOV	R3,#SKEY	; SKEY SENDEN
SETLS1:	ANL	A,#0FAH		; RESET LOCAL/SETUP FLAGS
	ORL	A,#40H		; BIT6 (TFLAG) SETZEN
	MOV	@R1,A		; NEUES BOOLEAN FLAG
	MOV	R1,#TBUFF
	MOV	A,R3
SETLS2:	MOV	@R1,A		; ZCHN IN TBUFF / BOOLEAN FLAG
	MOVL	A,R1
	MOV	A,HACC
	MOV	R5,A		; RB RETTEN (NACH R5)
	SEL	MB2
	CALL	STMODE		; STATUS NEU SETZEN
	SEL	MB0
	MOV	A,R5
	MOV	HACC,A
	MOVL	R1,A		; RB WIEDERHERSTELLEN
	JMP	EXTRET		; WARTEN / RETURN

; TASTE SETUP WURDE BET[TIGT. SETUP-FLAG WIRD INVERTIERT.
; WENN LOCAL-MODE AKTIV WAR, WIRD LKEY ZUM HOST GESENDET.
; BEI VERWENDUNG VON 2K-RAMS (SW4-0) KEIN SETUP-MODE!

SETSET:	MOV	R1,#REG4
	MOV	A,@R1		; REG4 ENTH[LT RAM-GR\SSE
	CPL	A
	JB0	EXTIN1		; 2K-RAM'S: AUCH SKEY AN HOST
	MOV	R1,#7
	MOV	A,@R1		; BOOLEAN FLAG
	JB0	SETSL		; LOCAL AKTIV: LKEY SENDEN
	XRL	A,#4		; TOGGLE SETUP FLAG
	JMP	SETLS2		; WARTEN / RETURN

SETSL:	MOV	R3,#LKEY
	JMP	SETLS1		; LKEY SENDEN, STATUS ANZ.

; EINGABE-STATUS ABFRAGEN. WENN ZEICHEN DA, R]CKKEHR MIT
; A>0. BEI ONLINE WIRD TBUFF GESENDET, FALLS VOLL.

STATUS:	MOV	A,R7		; BOOLEAN FLAG
	JB0	STALOC		; LOCAL: TFLAG PR]FEN
	CPL	A
	JB6	STAT2		; TBUFF LEER: WEITER
STAT1:	MOV	A,STAT
	CPL	A
	JB5	STAT1		; WARTEN AUF TX-EMPTY
	MOV	R0,#TBUFF
	MOV	A,@R0
	OUT	XMTR		; ZEICHEN SENDEN
	MOV	A,R7
	ANL	A,#0BFH		; TFLAG R]CKSETZEN
	MOV	R7,A
STAT2:	MOV	R0,#WRPTR
	DIS	II		; POINTER UNVER[NDERT !
	MOV	A,@R0
	INC	R0
	XRL	A,@R0		; ERGIBT 0 WENN RDPTR = WRPTR
	EN	II
	RET
STALOC:	ANL	A,#40H		; TFLAG MASKIEREN
	RET

; KONSOLEN-INPUT-ROUTINE. HOLT ZEICHEN VON DER HOSTSCHNITT-
; STELLE AUS RINGPUFFER (BEI LOCAL AUS TBUFF). SETZT BEI
; LEEREM RINGPUFFER DTR WIEDER. ZEICHEN WIRD IN R3 ]BERGEBEN.
; WENN TFLAG GESETZT IST, WIRD DAS ZEICHEN AUS DEM TASTEN-
; PUFFER ZUM HOST GESENDET (ONLINE).

CI:	CALL	STATUS		; ETWAS DA ?
	JZ	CI
CI1:	MOV	A,R7		; BOOLEAN FLAG
	JB0	CILOC		; LOCAL: ZCHN AUS TBUFF HOLEN
	MOV	A,@R0		; R0 ENTH[LT NOCH #RDPTR
	MOV	R1,A		; R1 = RDPTR
	MOV	A,@R1		; ZEICHEN
	MOV	R3,A		; NACH R3 ZUR ]BERGABE
	INC	R1		; RDPTR ERH\HEN, ...
	MOV	A,R1
	ANL	A,#RNGEND	; ... MASKIEREN, ...
	MOV	@R0,A		; ... ABSPEICHERN.
	CALL	STAT2		; PUFFER JETZT LEER ?
	JNZ	CIRET		; NEIN: ENDE
	ANL	PORT,#NOT DTR	; SONST DTR WIEDER SETZEN
	MOV	A,R7		; BOOLEAN FLAG
	CPL	A
	JB5	CIRET		; HANDSHAKE SCHON AUS: ENDE
	XRL	A,#0DFH		; FLAG R]CKSETZEN
	MOV	R7,A
	MOV	R1,#REG4	; ZEIGER AUF REG4
	MOV	A,@R1		; REG4 LESEN
	CPL	A
	JB5	CIRET		; HARDWARE-HANDSHAKE: ENDE
CI2:	MOV	A,STAT
	CPL	A
	JB5	CI2		; WARTEN AUF TRANSMITTER EMPTY
	MOV	A,#XONC
	OUT	XMTR		; XON AUSGEBEN
CIRET:	RET

CILOC:	ANL	A,#0BFH		; TFLAG R]CKSETZEN
	MOV	R7,A		; NEUES BOOLEAN FLAG
	MOV	R0,#TBUFF
	MOV	A,@R0		; LOCAL: ZEICHEN AUS TBUFF
	MOV	R3,A
	RET

; AUSGABE EINES ZEICHENS (IN R3) AN DEN HOSTRECHNER

CO:	MOV	A,STAT
	CPL	A
	JB5	CO		; WARTEN AUF TRANSMITTER EMPTY
	MOV	A,R3
	OUT	XMTR		; ZEICHEN AUSGEBEN
	RET

; KALTSTARTEINSPRUNG. ERST INITIALISIERUNGEN, SP[TER HAUPT-
; SCHLEIFE ZUR VERARBEITUNG EINZELNER ANKOMMENDER ZEICHEN.

START:	MOV	A,#14H
    IF MHZ12
	MOV	SCR,A		; SCR SETZEN : CPU CLK /1.0
    ELSE
	NOP			; GLEICHE CODE-L[NGE !
    ENDIF
	MOV	A,#DTR OR BELBIT
	OUT	PORT		; DTR R]CKSETZEN
	MOV	A,#90H
	MOV	MASK,A		; RCVR FULL & REAL TIME INT.ENA
	MOV	R0,#3FH
	CLR	A
START1:	MOV	@R0,A
	DJNZ	R0,START1	; ZUERST RAM MIT NULL F]LLEN
	MOV	R0,#REG4
	MOV	A,#80H
	CALL	REGX		; SWITCH 4 LESEN
	MOV	@R0,A		; NACH REG4 KOPIEREN
	INC	R0
	MOV	A,#0A0H
	CALL	REGX		; SWITCH 5 LESEN
	MOV	@R0,A		; NACH REG5 KOPIEREN
	INC	R0
	MOV	A,#0C0H
	CALL	REGX		; SWITCH 6 LESEN
	MOV	@R0,A		; NACH REG6 KOPIEREN
	MOV	R0,#WRPTR
	MOV	@R0,#RING
	INC	R0
	MOV	@R0,#RING	; RINGPUFFER LEER
	MOV	R0,#CURATT
	MOV	@R0,#0FFH	; CURATT: KEINE ATTR AKTIV
	INC	R0
	MOV	@R0,#0FEH	; MASK7: REVERSE ON
	CLR	A
	MOV	HACC,A
	MOV	HOME,A		; HOME UND CURS AUF NULL SETZEN
	MOV	CURS,A
	CALL	INIT		; INITIALISIEREN
	EN	II
	EN	XI
	ANL	PORT,#NOT DTR	; DTR SETZEN : TERMINAL BEREIT
	SEL	MB2
	CALL	STSET		; STATUSZEILE SETZEN
	JMP	FFD		; SCHIRM L\SCHEN, HAUPTSCHLEIFE

; ANZEIGEN DER AKTUELLEN CURSORPOSITION (ZEILE,SPALTE) SOWIE
; DER UHRZEIT IN DER STATUSZEILE. DIES GESCHIEHT IMMER WENN
; DAS TERMINAL AUF WEITERE BEFEHLE WARTET. DIE ANZEIGE NIMMT
; INSGESAMT MAX. 209c=262us IN ANSPRUCH.

DSP10:	MOV	R1,#'0'-1	; ZEHNER NOCH NULL
DSP101:	INC	R1
	ADD	A,#-10		; 10 SUBTRAHIEREN
	JC	DSP101		; 1 ZEHNER MEHR, WEITER
DSP102:	ADD	A,#10+'0'	; EINER ASCII 0..9
	MOV	R2,A
	MOVX	A,@R0		; ATTR LESEN
	MOV	A,R3
	MOVX	@R0,A		; 'R' BZW. 'C' AUSGEBEN
	INCL	R0
	MOV	A,R1
	MOVX	@R0,A		; ZEHNER AUSGEBEN
	INCL	R0
	MOV	A,R2
	MOVX	@R0,A		; EINER AUSGEBEN
	INCL	R0
	INCL	R0		; ZEIGER AUF N[CHSTE ANGABE
	RET

DISPL:	MOV	R0,#REG4
	MOV	A,@R0		; SWITCH 4
	CPL	A
	JB7	HLOOP		; STATUSZEILE AUS: ENDE DISPL
	SEL	MB2
	CALL	LDSEND		; STARTADRESSE STATUSZEILE
	SEL	MB0
	ADD	A,#54		; AUSGABE AB SPALTE 55
	MOVL	R0,A		; NACH R0
	MOV	A,R5		; ZEILE
	MOV	R3,#'R'
	CALL	DSP10		; DEZIMAL AUSGEBEN
	MOV	A,R6		; SPALTE
	MOV	R3,#'C'
	CALL	DSP10		; DEZIMAL AUSGEBEN
	MOV	R1,#HOUR
	MOV	R3,#3
DISPRT:	INCL	R0
	INCL	R0		; ZWISCHENRAUM ]BERGEHEN
	MOV	A,@R1
	SWAP	A
	ANL	A,#0FH		; HIGH-NYBBLE
	ORL	A,#'0'		; ASCII-OFFSET
	MOVX	@R0,A		; ZIFFER AUSGEBEN
	INCL	R0
	MOV	A,@R1
	ANL	A,#0FH		; LOW-NYBBLE
	ORL	A,#'0'		; ASCII-OFFSET
	MOVX	@R0,A		; ZIFFER AUSGEBEN
	INC	R1
	DJNZ	R3,DISPRT	; ALLE 3 BYTES AUSGEBEN

; HAUPTSCHLEIFE F]R ANKOMMENDE ZEICHEN.
; IST NICHTS ZU TUN, WERDEN CURSORPOS. UND UHR ANGEZEIGT.

HLOOP:	MOV	A,R7		; BOOLEAN FLAG
	JB2	SETUPY		; BIT 2 = 1 : SETUP
	CALL	STATUS		; ZEICHEN DA ?
	JZ	DISPL		; NEIN... CURSOR/UHR ANZEIGEN
	CALL	CI1		; ZEICHEN HOLEN
	MOV	A,R3
	ANL	A,#0E0H		; NUR 0..1F CONTROL
	JZ	CTLCD		; CTL: BEARBEITEN
	ANL	A,#060H		; INNERHALB 80..9F ?
	JZ	CTLZUS		; SPEZIALBEREICH BEARBEITEN
HLOOP1:	CALL	DISPIT
	JMP	HLOOP		; CURSOR-UP'S ERFORDERN CALL

SETUPY:	SEL	MB1
	JMP	SETUP		; SETUP-MEN]

; ZEICHEN 00..1F BEARBEITEN: CONTROL-CODES

CTLCD:	MOV	A,R7		; BOOLEAN FLAG
	JB1	CTLMOD		; CONTROL-MODE ON: DARSTELLEN
	SEL	MB2
	JMP	CTLCOD		; CONTROL-CODE BEARBEITEN
CTLMOD:	MOV	A,R3
	ADD	A,#'@'		; --> SICHTBARE ZEICHEN
	MOV	R3,A
	CALL	TRANSN		; EVTL. ZEICHEN TRANSFORMIEREN
	MOV	A,#0FCH		; HALF INTEN REVERSE
	MOV	HACC,A
	CALL	NORH1		; ZEICHEN AUF SCHIRM
	JMP	HLOOP

; HIER WERDEN DIE ZEICHEN ZWISCHEN 80 UND 9F BEARBEITET. IM
; GRAFIK-MODUS WERDEN DIESE ZEICHEN DARGESTELLT, ANSONSTEN WIRD
; IN EINER TABELLE GESCHAUT, OB DAS ZEICHEN DARGESTELLT ODER
; ALS CONTROL-FUNKTION INTERPRETIERT WERDEN SOLL.

CTLZUS:	MOV	R0,#CURATT
	MOV	A,@R0
	CPL	A
	JB7	HLOOP1		; GRAFIK: ZEICHEN DARSTELLEN
	MOV	A,R3
	ANL	A,#1FH		; NUR UNTERE 5 BIT ENTSCHEIDEND
	ADD	A,#LOW(KEYTAB)
	MOVP3	A,@A		; ZEICHEN AUS TABELLE LESEN
	JB7	CTLZU1		; OBERSTES BIT 1 : DARSTELLEN
	SEL	MB2
	JMP	CTLCD2		; ]BER INDTAB INTERPRETIEREN
CTLZU1:	ANL	A,#7FH		; OBERSTES BIT R]CKSETZEN (ATT!)
	MOV	R3,A		; NACH R3 ZUR DARSTELLUNG
	JMP	HLOOP1

; ZEICHENSATZ-TRANSFORMATION. DIE ZEICHENPAARE STEHEN HINTER-
; EINANDER IN EINER TABELLE. TABELLENENDE IST MIT 0 MARKIERT.
; DAS MSB (BIT7) WIRD UNVER[NDERT ]BERNOMMEN. DIE TABELLEN
; M]SSEN SICH IN PAGE 3 BEFINDEN (MOVP3 - BEFEHL) !

TRANSN:	MOV	R0,#NATTAB	; AKTUELLER ZEICHENSATZ
	MOV	A,@R0
	MOV	R2,A		; ZEIGER NACH R2
TRANS:	MOV	A,R2
	MOVP3	A,@A		; ZEICHEN AUS TABELLE
	JZ	NOTFND		; 0 = TABELLENENDE
	INC	R2		; ZEIGER AUF ERGEBNIS
	XRL	A,R3		; MIT R3 VERGLEICHEN
	ANL	A,#7FH		; OBERSTES BIT NICHT BEACHTEN
	JZ	FOUND		; EINGANG ERKANNT
	INC	R2		; ZEIGER AUF N[CHSTEN WERT
	JMP	TRANS		; SONST WEITERSUCHEN
FOUND:	MOV	A,R3		; ALTER WERT
	RLC	A		; BIT 7 INS CARRY
	MOV	A,R2		; ERGEBNISZEIGER
	MOVP3	A,@A		; AUSGANG HOLEN
	RL	A		; LINKS SCHIEBEN
	RRC	A		; BIT 7 AUS ORIG. EINSETZEN
	MOV	R3,A		; NACH R3
	CLR	C
	RET			; RETURN OHNE CARRY

NOTFND:	DEC	R2		; SETZT CARRY (WENN R2>0)
	RET			; RETURN MIT CARRY, R3 UNV.

; TABELLEN F]R BAUDRATENTEILER-INIT. GEH\REN ZU 'SETBOD'.
; M]SSEN IN PAGE 3 LIEGEN!

	ORG	300H

    IF MHZ12
BODTAB:	DB	18H,59H,0FFH,7FH,191,95,63,47
	DB	31,23,15,11,5,5,5,11
PSRTAB:	DB	64H,63H,62H,61H,60H,60H,60H,60H
	DB	60H,60H,60H,60H,60H,60H,60H,60H
    ENDIF
    IF MHZ18
BODTAB:	DB	53H,5AH,0E7H,0F3H,249,124,137,132
	DB	47,65,23,17,8,8,8,17
PSRTAB:	DB	85H,84H,83H,81H,80H,80H,20H,00H
	DB	60H,00H,60H,60H,60H,60H,60H,60H
    ENDIF

; TRANSFORMATIONSTABELLEN F]R SONDERZEICHEN. 12-MHZ-TABELLEN
; K]NSTLICH VERL[NGERT WEGEN STARTADRESSEN-GLEICHHEIT.
; TABELLEN M]SSEN SICH IN PAGE 3 BEFINDEN !

    IF MHZ12
NATUSA:	DB	0
NATFRA:	DB	40H,12H,5BH,6,5CH,18H,5DH,7,7BH,17H,7CH,16H
	DB	7DH,13H,7EH,5,0
NATGER:	DB	40H,7,5BH,0BH,5CH,0CH,5DH,0EH,7BH,1BH,7CH,1CH
	DB	7DH,1EH,7EH,11H,0
NATGB:	DB	23H,3,0
NATDEN:	DB	5BH,0AH,5CH,2,5DH,0DH,7BH,1AH,7CH,2,7DH,1DH,0
NATSWE:	DB	24H,4,5BH,0BH,5CH,0CH,5DH,0DH,5EH,0EH,60H,17H
	DB	7BH,1BH,7CH,1CH,7DH,1DH,7EH,1EH,0,0,0
NATITA:	DB	5BH,6,5DH,17H,60H,16H,7BH,12H,7CH,1CH,7DH,13H
	DB	7EH,14H,0
NATSPA:	DB	5BH,14H,5CH,9,7BH,5,7CH,19H,0,0,0,0,0
    ENDIF
    IF MHZ18
NATUSA:	DB	0
NATFRA:	DB	40H,1BH,5BH,14H,5CH,0AH,5DH,0CH,7BH,19H
	DB	7CH,1AH,7DH,0BH,7EH,1CH,0
NATGER:	DB	40H,0CH,5BH,1,5CH,2,5DH,3,7BH,11H,7CH,12H
	DB	7DH,13H,7EH,4,0
NATGB:	DB	23H,0,0
NATDEN:	DB	5BH,6,5CH,7,5DH,5,7BH,16H,7CH,17H,7DH,15H,0
NATSWE:	DB	24H,10H,40H,9,5BH,1,5CH,2,5DH,5,5EH,3
	DB	60H,19H,7BH,11H,7CH,12H,7DH,15H,7EH,13H,0
NATITA:	DB	5BH,14H,5DH,19H,60H,1AH,7BH,1BH,7CH,12H
	DB	7DH,0BH,7EH,0DH,0
NATSPA:	DB	23H,1EH,5BH,0DH,5CH,8,5DH,0EH,7BH,1CH
	DB	7CH,18H,0
    ENDIF

; DIE FOLGENDE TABELLE DIENT ZUR UNIVERSELLEN BEARBEITUNG DER
; CODES 80..9F. JEDEM DIESER CODES WIRD EIN BYTE AUS DER TABELLE
; ZUGEORDNET. LIEGT DIES INNERHALB 80..9F, SO WIRD ES AUF DEM
; BILDSCHIRM DARGESTELLT (DIE UNTEREN 7 BIT), ANSONSTEN WIRD ES
; ALS CONTROL-FUNKTIONSCODE INTERPRETIERT (WEITERE VERARBEITUNG
; ]BER INDTAB). DEFAULT: NUR CR UND LF ALS CONTROLCODE.

KEYTAB:	DB	80H,81H,82H,83H,84H,85H,86H,87H
	DB	88H,89H,003,8BH,8CH,006,8EH,8FH
	DB	90H,91H,92H,93H,94H,95H,96H,97H
	DB	98H,99H,9AH,9BH,9CH,9DH,9EH,9FH

; DIE N[CHSTE TABELLE DIENT ZUR BEARBEITUNG DER SWITCH-TASTEN
; EINER SERIELLEN TASTATUR (ALT,CTL,SHIFT). DIE EINTR[GE SIND
; DIREKT DIE BITMASKEN ZUR VER[NDERUNG VON BFLAG2.

SWTAB:	DB	2AH,1,36H,1,1DH,2,38H,4,3AH,48H,45H,50H,0

; ZEICHEN DARSTELLEN UNTER BER]CKSICHTIGUNG DER AKTUELLEN ATTR.

DISPIT:	MOV	R0,#CURATT
	MOV	A,@R0		; CURRENT ATTRIBUTE
	JB7	DISP1		; KEINE GRAFIK
	MOV	A,R3
	ADD	A,#-' '		; OFFSET SUBTRAHIEREN
	MOV	R3,A
	JMP	DISP2		; KEINE TRANSFORMATION
DISP1:	CALL	TRANSN		; EVTL. ZEICHENSATZ BEACHTEN
DISP2:	MOV	R0,#CURATT
	MOV	A,@R0		; AKTUELLE ATTRIBUTE LADEN
	JB4	NORWID		; NORMALE BREITE

	CALL	NORWID		; DOPPELTE BREITE: NOCHMAL
	MOV	R0,#CURATT
	MOV	A,@R0		; CURATT

NORWID:	JB3	NORHEI		; NORMALE H\HE
	SEL	MB2
	CALL	CURUP		; ZEILE H\HER
	MOV	A,@R0
	MOV	HACC,A		; CURRENT ATTRIBUTE
	MOV	A,R3
	CPL	A
	JB7	NORW1		; BIT 7 = 0 : ATTR. UNVER[ND.
	MOV	A,HACC
	MOV	R0,#MASK7
	ANL	A,@R0		; ZWEIT-ATTRIBUTE SETZEN
	MOV	HACC,A
NORW1:	MOV	A,R3
	MOVX	@CURS,A		; ZEICHEN ABSPEICHERN
	CALL	CDOWN		; WIEDER ZEILE RUNTER (MB2)
	MOV	R0,#CURATT
	MOV	A,@R0
	ANL	A,#0BFH		; BLANK SETZEN

NORHEI:	MOV	HACC,A
	MOV	A,R3		; ZEICHEN
	CPL	A
	JB7	NORH1		; BIT 7 = 0 : ATTR. UNVER[ND.
	MOV	R0,#MASK7
	MOV	A,HACC
	ANL	A,@R0		; ZWEIT-ATTRIBUTE SETZEN
	MOV	HACC,A
NORH1:	MOV	A,R3
	MOVX	@CURS,A		; AN CURSORPOSITION ABSPEICHERN
	SEL	MB2		; (FALLS VON CTLMOD)
	JMP	CRIGHT		; CURSOR NACH RECHTS UND WEITER

; EINLESEN DER SERIELLEN IBM-TASTATUR. DIE AKTIVE CLOCK-FLANKE
; ZUR INTERRUPTAUSL\SUNG MUSS AUF FALLEND EINGESTELLT SEIN.
; DIE DATEN WERDEN JEWEILS BEI DER FALL. TAKTFL. ]BERNOMMEN.
; VERZ. 1.CLK-FLANKE BIS 1.LESEN CLK	29c =	24us
; MIN. DAUER CLK=H			 5c =	 7us
; MIN. DAUER CLK=L			 6c =	 8us
; VERZ. FESTST. CLK=H BIS PR]FEN CLK=L	 7c =	 9us
; VERZ. FESTST. CLK=L BIS PR]FEN CLK=H	11c =	14us
; MIN. ZYKLUSDAUER TASTATUR (OPT.BED.)  18c =	23us

	ORG	400H

SERIN:	MOV	R1,#0		; BITZ[HLER
SERIN0:	IN	PORT
	CPL	A
	JB1	SERIN0		; WARTEN AUF CLK=H (UNBEGRENZT)
	MOV	R0,#20		; TIME-OUT CA. 150 US
SERIN1:	IN	PORT
	JB1	SERIN2		; WARTEN AUF CLK=L (TIME-OUT)
	RRC	A		; DATENBIT AUS DATA 0 IN CARRY
	MOV	A,R3
	RRC	A		; IN TASTATUR-CODE EINSCHIEBEN
	MOV	R3,A
	INC	R1
	JMP	SERIN0		; WEITER
SERIN2:	DJNZ	R0,SERIN1	; TIME-OUT-SCHLEIFE
	MOV	A,R1		; ANZAHL BITS
	JB3	SERIN3		; BEREICH 8..15 : OK
	JMP	EXTRET		; NICHT 8..15 : IGNORIEREN

; EINGELESENER TASTENCODE IN R3 UND A WIRD NUN AUF SPEZIAL-
; FUNKTION ]BERPR]FT UND ANSONSTEN JE NACH AKTUELLEM STATUS
; DURCH VERSCHIEDENE TABELLEN IN DEN ASCII-WERT GEWANDELT.

SERIN3:	MOV	R1,#BFLAG2	; BOOLEAN FLAG 2 F]R SER. TAST.
	MOV	R2,#LOW(SWTAB)
	CALL	TRANS		; SPEZIALTASTEN TRANSFORMIEREN
	JNC	SHKEY		; ALT/CTL/SHIFT GES. BEARB.
	MOV	A,R3		; TASTENCODE
	JB7	IGKEY		; ALLE ANDEREN : OFF IGNORIEREN
	ADD	A,#-47H
	JC	NKEY		; AB TC 47H : NUMLOCK-BLOCK
NNUML:	MOV	A,@R1		; BFLAG2
	JB2	ALTKEY
	MOV	R2,#LOW(CTABLE)	; ZEIGER VORBELEGEN (CTL)
	JB1	TRKEY
	MOV	R2,#LOW(STABLE)	; ZEIGER VORBELEGEN (SHIFT)
	JB0	TRKEY
	MOV	R2,#LOW(NTABLE)	; ZEIGER NORMALZEICHEN
TRKEY:	MOV	A,R3		; TASTENCODE
	ADD	A,R2		; TABELLENADRESSE BERECHNEN
	CALL	GETKEY		; ZEICHEN AUS ENTSPR. TAB. HOLEN
TRKEY1:	MOV	R3,A		; NACH R3 ZUR WEITEREN VERW.
	INC	A
	JZ	IGKEY		; BEI TABELLENWERT -1 IGNORIEREN
	MOV	A,@R1		; BFLAG2
	CPL	A
	JB3	SERX		; CAPSLOCK INAKTIV: UNVER[NDERT
	MOV	A,R3		; ASCII-ZEICHEN
	ADD	A,#-'a'
	JNC	SERX		; UNTERHALB VON 'a': UNVER[NDERT
	ADD	A,#'a'-'}'-1
	JC	SERX		; OBERHALB VON '}': UNVER[NDERT
	MOV	A,R3
	XRL	A,#20H		; KLEIN <--> GROSS
	MOV	R3,A
SERX:	JMP	SERRET		; MIT ZEICHEN ZUR]CK (IN R3)

; AUSWERTUNG DER SPEZIALTASTEN SHIFT/CTL/ALT/NUMLOCK/CAPSLOCK.

SHKEY:	JB6	TOGF		; BEI GES. BIT6 : CAPS/NUM LOCK
	JB7	RESF		; BEI GESETZTEM BIT7 : RESET
	ORL	A,@R1		; BIT SETZEN
	JMP	FRET		; ZUR]CK
RESF:	CPL	A		; KOMPLEMENTIERTE BITMASKE
	ANL	A,@R1		; BIT R]CKSETZEN
FRET:	MOV	@R1,A
IGKEY:	JMP	EXTRET		; ZUR]CK OHNE WEITERE BEARB.

; ALT-TASTE GEDR]CKT: KOMPLETT ANDERE TABELLE BENUTZEN.

ALTKEY:	MOV	A,R3		; TASTENCODE
	ADD	A,#LOW(ATABLE)	; TABELLENANFANG ADDIEREN
AKEY:	CALL	GETK1		; ANDERE LESEROUTINE
	JMP	TRKEY1		; WEITER WIE NORM/SHIFT/CTL

; TASTE IM CURSOR/ZIFFERNBLOCK: NUMLOCK PR]FEN, BEI NUMLOCK
; ANDERE TABELLE BENUTZEN (DANN OHNE SHIFT/CTL/ALT).

NKEY:	MOV	A,@R1		; BFLAG2
	CPL	A
	JB4	NNUML		; NUM-LOCK INAKTIV: NORMAL
	MOV	A,R3		; TASTENCODE
	ADD	A,#LOW(LTABLE)-47H ; ZEIGER AUF NUM-LOCK-TABELLE
	JMP	AKEY		; WEITER WIE BEI ALT

; AUSWERTUNG DER UMSCHALTENDEN TASTEN NUMLOCK/CAPSLOCK

TOGF:	CPL	A
	JB7	IGKEY		; ON IGNORIEREN (AUTOREPEAT!)
	MOV	A,@R1		; BFLAG2
	XRL	A,R3		; BIT INVERTIEREN
	JMP	FRET		; ZUR]CK

; ROUTINE ZUM LESEN DER ASCII-CODES AUS DEN TABELLEN IN PAGE 4

GETK1:	MOVP	A,@A		; ZEICHEN AUS TABELLE HOLEN
	RET			; UND ZUR]CK ZUM AUFRUF

; TABELLE DER TASTENCODES BEI GEDR]CKTER ALT-TASTE

ATABLE:	DB	 -1,1BH,31H,40H,00H,34H,35H,36H ; 00..07
	DB	37H,38H,39H,30H,7EH,27H,08H,09H ; 08..0F
	DB	71H,77H,65H,72H,74H,7AH,75H,69H ; 10..17
	DB	6FH,70H,7DH,2BH,0DH, -1,61H,73H ; 18..1F
	DB	64H,66H,67H,68H,6AH,6BH,6CH,7CH ; 20..27
	DB	7BH,23H, -1,3CH,79H,78H,63H,76H ; 28..2F
	DB	62H,6EH,6DH,2CH,2EH,2DH, -1,2AH ; 30..37
	DB	 -1,20H, -1, -1, -1, -1, -1, -1 ; 38..3F
	DB	 -1, -1, -1, -1, -1, -1, -1,37H ; 40..47
	DB	38H,39H,2DH,34H,35H,36H,2BH,31H ; 48..4F
	DB	32H,33H,30H,2EH			; 50..53

; TABELLE DER TASTENCODES BEI AKTIVEM NUM-LOCK-MODUS

LTABLE:	DB	37H,38H,39H,2DH,34H,35H,36H,2BH ; 47..4E
	DB	31H,32H,33H,30H,2EH		; 4F..53

	ORG	500H		; WEITERE TABELLEN IN EIG. PAGE

; ROUTINE ZUM LESEN DER ASCII-CODES AUS DEN TABELLEN IN PAGE 5

GETKEY:	MOVP	A,@A		; ZEICHEN AUS TABELLE HOLEN
	RET			; UND ZUR]CK ZUM AUFRUF

; TABELLE DER NORMALEN ASCII-CODES (OHNE SHIFT/CTL/ALT)
; TABELLENEINTR[GE VOM WERT -1 (FFH) WERDEN IGNORIERT.

NTABLE:	DB	 -1,1BH,31H,32H,33H,34H,35H,36H ; 00..07
	DB	37H,38H,39H,30H,7EH,27H,08H,09H ; 08..0F
	DB	71H,77H,65H,72H,74H,7AH,75H,69H ; 10..17
	DB	6FH,70H,7DH,2BH,0DH, -1,61H,73H ; 18..1F
	DB	64H,66H,67H,68H,6AH,6BH,6CH,7CH ; 20..27
	DB	7BH,23H, -1,3CH,79H,78H,63H,76H ; 28..2F
	DB	62H,6EH,6DH,2CH,2EH,2DH, -1,2AH ; 30..37
	DB	 -1,20H, -1, -1, -1, -1, -1, -1 ; 38..3F
	DB	 -1, -1, -1, -1, -1, -1, -1,17H ; 40..47
	DB	05H,12H,2DH,13H,35H,04H,2BH,1AH ; 48..4F
	DB	18H,03H,16H,7FH			; 50..53

; TABELLE DER TASTENCODES BEI GEDR]CKTER SHIFT-TASTE

STABLE:	DB	 -1,1BH,21H,22H,40H,24H,25H,26H ; 00..07
	DB	2FH,28H,29H,3DH,3FH,60H,08H,09H ; 08..0F
	DB	51H,57H,45H,52H,54H,5AH,55H,49H ; 10..17
	DB	4FH,50H,5DH,2AH,0DH, -1,41H,53H ; 18..1F
	DB	44H,46H,47H,48H,4AH,4BH,4CH,5CH ; 20..27
	DB	5BH,5EH, -1,3EH,59H,58H,43H,56H ; 28..2F
	DB	42H,4EH,4DH,3BH,3AH,5FH, -1,2AH ; 30..37
	DB	 -1,20H, -1, -1, -1, -1, -1, -1 ; 38..3F
	DB	 -1, -1, -1, -1, -1, -1, -1,17H ; 40..47
	DB	05H,12H,2DH,01H,35H,06H,2BH,1AH ; 48..4F
	DB	18H,03H,16H,7FH			; 50..53

; TABELLE DER TASTENCODES BEI GEDR]CKTER CTL-TASTE

CTABLE:	DB	 -1,1BH,31H,32H,33H,34H,35H,36H ; 00..07
	DB	37H,38H,39H,30H,7EH,27H,08H,09H ; 08..0F
	DB	11H,17H,05H,12H,14H,1AH,15H,09H ; 10..17
	DB	0FH,10H,1DH,2BH,0DH, -1,01H,13H ; 18..1F
	DB	04H,06H,07H,08H,0AH,0BH,0CH,1CH ; 20..27
	DB	1BH,1EH, -1,1CH,19H,18H,03H,16H ; 28..2F
	DB	02H,0EH,0DH,2CH,2EH,1FH, -1,2AH ; 30..37
	DB	 -1,20H, -1, -1, -1, -1, -1, -1 ; 38..3F
	DB	 -1, -1, -1, -1, -1, -1, -1,17H ; 40..47
	DB	05H,12H,2DH,13H,35H,04H,2BH,1AH ; 48..4F
	DB	18H,03H,16H,7FH			; 50..53

	END
 